import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**Specially designed to take the determinant of a 5x5 matrix*/


public class Matrix {
    double[][] a=new double[5][5];


    public Matrix(){}

    public double det() {
	double tot=0;
	for(int k=0;k<120;++k) tot=tot+term(k);
	return(tot);
    }

    public double term(int k) {
	double s=1;
	if(sign(k)==1) s=-1;
	int[] p=permutation(k);
	for(int i=0;i<5;++i) s=s*a[i][p[i]];
	return(s);
    }

    public static int sign(int k) {
	int count=0;
	int[] a=permutation(k);
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		if(a[i]>a[j]) ++count;
	    }
	}
	return(count%2);
    }

    public static int[] permutation(int k) {
	int[][] a={{0,1,2,3,4},{0,1,2,4,3},{0,1,3,2,4},{0,1,3,4,2},{0,1,4,2,3},{0,1,4,3,2},{0,2,1,3,4},{0,2,1,4,3},{0,2,3,1,4},{0,2,3,4,1},{0,2,4,1,3},{0,2,4,3,1},{0,3,1,2,4},{0,3,1,4,2},{0,3,2,1,4},{0,3,2,4,1},{0,3,4,1,2},{0,3,4,2,1},{0,4,1,2,3},{0,4,1,3,2},{0,4,2,1,3},{0,4,2,3,1},{0,4,3,1,2},{0,4,3,2,1},{1,0,2,3,4},{1,0,2,4,3},{1,0,3,2,4},{1,0,3,4,2},{1,0,4,2,3},{1,0,4,3,2},{1,2,0,3,4},{1,2,0,4,3},{1,2,3,0,4},{1,2,3,4,0},{1,2,4,0,3},{1,2,4,3,0},{1,3,0,2,4},{1,3,0,4,2},{1,3,2,0,4},{1,3,2,4,0},{1,3,4,0,2},{1,3,4,2,0},{1,4,0,2,3},{1,4,0,3,2},{1,4,2,0,3},{1,4,2,3,0},{1,4,3,0,2},{1,4,3,2,0},{2,0,1,3,4},{2,0,1,4,3},{2,0,3,1,4},{2,0,3,4,1},{2,0,4,1,3},{2,0,4,3,1},{2,1,0,3,4},{2,1,0,4,3},{2,1,3,0,4},{2,1,3,4,0},{2,1,4,0,3},{2,1,4,3,0},{2,3,0,1,4},{2,3,0,4,1},{2,3,1,0,4},{2,3,1,4,0},{2,3,4,0,1},{2,3,4,1,0},{2,4,0,1,3},{2,4,0,3,1},{2,4,1,0,3},{2,4,1,3,0},{2,4,3,0,1},{2,4,3,1,0},{3,0,1,2,4},{3,0,1,4,2},{3,0,2,1,4},{3,0,2,4,1},{3,0,4,1,2},{3,0,4,2,1},{3,1,0,2,4},{3,1,0,4,2},{3,1,2,0,4},{3,1,2,4,0},{3,1,4,0,2},{3,1,4,2,0},{3,2,0,1,4},{3,2,0,4,1},{3,2,1,0,4},{3,2,1,4,0},{3,2,4,0,1},{3,2,4,1,0},{3,4,0,1,2},{3,4,0,2,1},{3,4,1,0,2},{3,4,1,2,0},{3,4,2,0,1},{3,4,2,1,0},{4,0,1,2,3},{4,0,1,3,2},{4,0,2,1,3},{4,0,2,3,1},{4,0,3,1,2},{4,0,3,2,1},{4,1,0,2,3},{4,1,0,3,2},{4,1,2,0,3},{4,1,2,3,0},{4,1,3,0,2},{4,1,3,2,0},{4,2,0,1,3},{4,2,0,3,1},{4,2,1,0,3},{4,2,1,3,0},{4,2,3,0,1},{4,2,3,1,0},{4,3,0,1,2},{4,3,0,2,1},{4,3,1,0,2},{4,3,1,2,0},{4,3,2,0,1},{4,3,2,1,0}};
return(a[k]);
    }

    public void print(String S) {
	System.out.println("");
	System.out.print(S);
	System.out.print("={");
	for(int i=0;i<5;++i) {
	    System.out.print("{");
	    for(int j=0;j<5;++j) {
		if(j<4) System.out.print(a[i][j]+",");
		if(j==4) System.out.print(a[i][j]);
	    }
	    if(i<4) System.out.print("},");
	    if(i==4) System.out.print("}");
	}
	System.out.print("}");
	System.out.println("");
    }








}




