import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This is the moduli space of pseudo tetrahedra.  The space 
   consists of 24 5-simplices.*/
  
 public class ModuliSpace {

     /**Here are the vertices*/


     public static double[][] vertex() {
	 double[][] a={
         {1,1,0,0,0},
         {0,0,1,1,0},
         {1,0,0,1,1},
         {0,1,1,0,1},
         {1,1,0,1,1},
         {0,1,1,1,1},
         {1,0,1,1,1},
         {1,1,1,1,0},
         {1,1,1,0,1},
         {1,.5,1,.5,.5},
         {.5,1,.5,1,.5},
         {1,1,1,1,1}};
    return(a);}


   public static int[] code(int k) {
      int[][] list={
        {0,1,2,3,4,6},
        {0,1,2,4,6,7},
        {0,1,3,4,5,8},
        {0,1,3,4,6,8},
        {0,1,3,5,7,8},
        {0,1,4,5,7,8},
        {0,1,4,5,7,10},
        {0,1,4,6,7,8},
        {0,1,6,7,8,9},
        {0,2,3,4,6,8},
        {1,2,3,4,5,6},
        {1,3,4,5,6,8},
        {1,4,5,6,7,8},
        {4,5,6,7,8,11}};
     return(list[k]);
}


     /**Here are the vertices*/
     public static double[] vertex(int k) {
	 double[][] a=vertex();
	 return(a[k]);
     }

     /**Here is a simplex*/
     public static double[][] simplex(int[] a) {
	 double[][] b={vertex(a[0]),vertex(a[1]),vertex(a[2]),vertex(a[3]),vertex(a[4]),vertex(a[5])};
	 return(b);
     }


     public static double[] triangleCenter(int a1,int a2,int a3) {
	 double[] t1=vertex(a1);
	 double[] t2=vertex(a2);
	 double[] t3=vertex(a3);
	 double[] u=new double[5];
	 for(int i=0;i<5;++i) u[i]=(t1[i]+t2[i]+t3[i])/3;
	 return(u);
     }


public static int[] extractList(int[] b) {
    int[] a=new int[12];
    int count=0;
    for(int j=0;j<b.length;++j) {
	if(b[j]==1) {
	    a[count]=j;
	    ++count;
	}
    }
    int[] aa=new int[count];
    for(int i=0;i<count;++i) aa[i]=a[i];
    return(aa);
}

public static double[] getRandom(int[] b) {
    int[] a=extractList(b);
    int tot=a.length;
    double[] r=new double[tot];
    for(int i=0;i<tot;++i) r[i]=Math.random();
    double sum=0;
    for(int i=0;i<tot;++i) sum=sum+r[i];
    for(int i=0;i<tot;++i) r[i]=r[i]/sum;

    double[] u=new double[5];
    for(int i=0;i<tot;++i) {
	double[] t=vertex(a[i]);
	for(int j=0;j<5;++j){
	    u[j]=u[j]+r[i]*t[j];
	}
    }
    return(u);
}

/**Gets a random point in the kth simplex*/
public static double[] getRandom(int k) {
    int[] b=new int[12];
    int[] a=code(k);
    int count=0;
    for(int i=0;i<12;++i) {
	if(count<6) {
	  if(i==a[count]) {
	    b[i]=1;
	    ++count;
	  }
	}
    }
    return(getRandom(b));
}


}

