import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**A monomial is an expression of the form 

c x0^{e0}...x4^{e4}

here c is a BigInteger and
e0,...,e4 are non-negative integer exponents.  We
keep track of c and e0,...,e4*/

public class Monomial {
    BigInteger c;
    int[] e=new int[5];

    public Monomial() {}

    public Monomial(Monomial a) {
	this.c=new BigInteger(a.c.toString());
	for(int i=0;i<5;++i) this.e[i]=a.e[i];
    }

    public Monomial(int c0,int[] ee) {
	c=copy(c0);
	for(int i=0;i<5;++i) e[i]=ee[i];
    }

    public Monomial(BigInteger c0,int[] ee) {
	c=new BigInteger(c0.toString());
	for(int i=0;i<5;++i) e[i]=ee[i];
    }


    /**multiplies the coefficient by 2^(mask-e0), assuming that mask-e0 is
       non-negative and less than 11.*/

    public Monomial dilate(int mask) {
	BigInteger TWO=new BigInteger("2");
	int a=mask-this.e[0];
	BigInteger A=this.c.multiply(TWO.pow(a));
	Monomial m=new Monomial(A,this.e);
	return(m);
    }

    /**permutes the coefficients by a cyclic permutation*/

    public Monomial rotate(int r) {
	Monomial m=new Monomial();
	m.c=new BigInteger(c.toString());
	for(int i=0;i<5;++i) {
	    int j=(i+5+r)%5;
	    m.e[j]=e[i];
	}
	return(m);
    }

    public static BigInteger copy(int a) {
	Integer A=new Integer(a);
	BigInteger AA=new BigInteger(A.toString());
	return(AA);
    }


    /**evaluation on integer vectors. This is for debugging purposes*/
    public BigInteger evaluate(int[] x) {
	BigInteger a=new BigInteger(c.toString());
	for(int i=0;i<5;++i) {
	    for(int j=0;j<e[i];++j) {
		a=a.multiply(copy(x[i]));
	    }
	}
	return(a);
    }
    
    /**printouts*/
    public void print() {
	System.out.print("["+c.toString()+"] (");
	for(int i=0;i<5;++i) {
	    System.out.print(e[i]);
	    if(i<4) System.out.print(" ");
	}
	System.out.print(") ");
    }





    public void println() {
	this.print();
	System.out.println("");
    }
}




