import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Lever SIMPLEX1,SIMPLEX2,SIMPLEX4,SIMPLEX6;
    ListenSquare GO0,GO1,STOP0,STOP1;
    Debugger DE;
    PositiveDominance PD;
    ControlPanel DEBUG,ACTION;
    CalculationMonitor CM;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(550,250,100);
	 GO0=new ListenSquare(5,280,25,20);  //debugger
	 STOP0=new ListenSquare(5,305,25,20); //debugger
	 GO1=new ListenSquare(370,15,25,20);   //posdom
	 STOP1=new ListenSquare(370,45,35,20); //posdom
	 SIMPLEX1=new Lever(175,100,0,2);
	 SIMPLEX4=new Lever(175,100,0,14);
	 SIMPLEX6=new Lever(400,100,0,14);
	 DE=new Debugger();
	 PD=new PositiveDominance();
	 CM=new CalculationMonitor(25,100);
	 setPanels();	
     }


    public void setPanels() {  
	Color[] C1={new Color(100,0,150),Color.white,Color.white,Color.white,new Color(180,180,180)};
	String[] DebugString={"cayley menger","functions","total space","positivity","g-4f check","g-6f check","poly dilate","poly rotate","poly reflect","partition","debugger"};
	int[] DebugState={1,0,0,0,0,0,0,0,0,0,0};
         DEBUG=new ControlPanel(C1,DebugString,DebugState,10);
	 DEBUG.mode=0;

	 String[] ActionString={"debugger","main result","extra","action"};
	 int[] ActionState={0,1,0};
         ACTION=new ControlPanel(C1,ActionString,ActionState,3);
	 ACTION.mode=1;

    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      if(ACTION.mode!=0) CM.render(g,PD.HALT);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,100));
        g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawControls(Graphics2D g) { 

	ACTION.render(g,5,5,140);

	/**Debugger mode*/
	if(ACTION.mode==0) {
           DEBUG.render(g,5,85,140);
	   GO0.render(g,"go",12,3,new Color(0,160,0));
	   if(DE.HALT==false) STOP0.render(g,"stop",12,3,new Color(255,0,0));
	}

	/**main result mode*/
	if(ACTION.mode==1) {
	    g.setFont(new Font("Helvetica",Font.PLAIN,12));
	    Color C1=new Color(70,0,100);
	    if(PD.HALT==false) C1=Color.black;
	    SIMPLEX4.render3(g,"",C1);
	    SIMPLEX6.render3(g,"",C1);
	     g.drawString("simplices for g-4f",90,90);
	     g.drawString("simplices for g-6f",320,90);
	     g.drawLine(181,95,181,130);
	     g.drawLine(406,95,406,130); 
             GO1.render(g,"go",12,3,new Color(0,160,0));
	     if(PD.HALT==false) STOP1.render(g,"stop",12,3,new Color(255,0,0));
	}

	/**extra result mode*/
	if(ACTION.mode==2) {
	    g.setFont(new Font("Helvetica",Font.PLAIN,12));
	    Color C1=new Color(70,0,100);
	    if(PD.HALT==false) C1=Color.black;
	    SIMPLEX1.render3(g,"",C1);
	     g.drawString("extra calcs",120,90);
	     g.drawLine(181,95,181,130);
             GO1.render(g,"go",12,3,new Color(0,160,0));
	     if(PD.HALT==false) STOP1.render(g,"stop",12,3,new Color(255,0,0));
	}


    }


/**This handles the launching of the programs*/
    public void action(Point X) {
	if((ACTION.mode==0)&&(GO0.inside(X)==1)) run0();
	if((ACTION.mode!=0)&&(GO1.inside(X)==1)) run1();
	if((ACTION.mode==0)&&(STOP0.inside(X)==1)) stop0();
	if((ACTION.mode!=0)&&(STOP1.inside(X)==1)) stop1();
    }

    public void run0() {
	if(DE.HALT==true) {
	  DE=new Debugger(this);
          new Thread(DE).start();
	}
    }

    public void run1() {
	if(PD.HALT==true) {
	  PD=new PositiveDominance(this);
          new Thread(PD).start();
	}
    }

    public void stop0() {
	DE.HALT=true;
    }

    public void stop1() {
	PD.HALT=true;
    }


/**Documentation for the debugger*/

    public void doDocDebug(int t) {
	if(ACTION.mode==1) return;
	if(t==0) DocumentDebugger.cayley(M.D);
	if(t==1) DocumentDebugger.functions(M.D);
	if(t==2) DocumentDebugger.totalspace(M.D);
	if(t==3) DocumentDebugger.positivity(M.D);
	if(t==4) DocumentDebugger.cubefunction4(M.D);
	if(t==5) DocumentDebugger.cubefunction6(M.D);
	if(t==6) DocumentDebugger.dilate(M.D);;
	if(t==7) DocumentDebugger.rotate(M.D);
	if(t==8) DocumentDebugger.reflect(M.D);
	if(t==9) DocumentDebugger.partition(M.D);
    }

    public void doDocAction(int t) {
	if(t==0) DocumentDebugger.actionDebug(M.D);
	if(t==1) DocumentDebugger.actionMain(M.D);
	if(t==2) DocumentDebugger.actionExtra(M.D);
    }



    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	action(J.X);
	int test=DEBUG.switchMode(J.X);
	doDocDebug(test);
	test=ACTION.switchMode(J.X);	
        if((PD.HALT==true)&&(ACTION.mode==1)) SIMPLEX4.toggle(J.X);
        if((PD.HALT==true)&&(ACTION.mode==1)) SIMPLEX6.toggle(J.X);
        if((PD.HALT==true)&&(ACTION.mode==2)) SIMPLEX1.toggle(J.X);
	doDocAction(test);
	repaint();


    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }


}

