import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class Polynomial {
    Monomial[] m=new Monomial[20000];
    int[] age=new int[5];
    int count;
    int[] marker=new int[2];

    public Polynomial() {}

    public Polynomial(Polynomial P) {
	this.count=P.count;
	for(int i=0;i<this.count;++i) this.m[i]=new Monomial(P.m[i]);
	for(int i=0;i<5;++i) age[i]=P.age[i];
	for(int i=0;i<2;++i) marker[i]=P.marker[i];

    }

    public Polynomial(int[][] a) {
	this.count=a.length;
	for(int i=0;i<this.count;++i) {
	    int c=a[i][0];
	    int[] b={a[i][1],a[i][2],a[i][3],a[i][4],a[i][5]};
	    this.m[i]=new Monomial(c,b);
	}
    }

    public BigInteger evaluate(int[] x) {
	BigInteger a=new BigInteger("0");
	for(int i=0;i<count;++i) {
	    a=a.add(m[i].evaluate(x));
	}
	return(a);
    }

    public int exponentLimit(int k) {
	int max=0;
	for(int i=0;i<count;++i) {
	    if(max<m[i].e[k]) max=m[i].e[k];
	}
	return(max);
    }

    public int[] exponentLimit() {
	int[] a=new int[5];
	for(int i=0;i<5;++i) a[i]=exponentLimit(i);
	return(a);
    }

    /**basic operations*/
    public Polynomial dilate() {
	Polynomial P=new Polynomial(this);
	int mask=this.exponentLimit(0);
	for(int i=0;i<count;++i) {
	    P.m[i]=m[i].dilate(mask);
	}
	return(P);
    }

    public Polynomial reflect() {
	BigInteger[][][][][] B=initialize();
	for(int i=0;i<this.count;++i) {
	    int[] t=pascalTriangle(m[i].e[0]);
            int[] e=m[i].e;
	    for(int j=0;j<t.length;++j) {
		BigInteger A=m[i].c.multiply(copy(t[j]));
	        B[j][e[1]][e[2]][e[3]][e[4]]= B[j][e[1]][e[2]][e[3]][e[4]].add(A);
	    }
	}
	Polynomial P=compress(B);
	for(int i=0;i<5;++i) P.age[i]=this.age[i];
	return(P);
    }

    public static BigInteger copy(int a) {
	Integer A=new Integer(a);
	BigInteger AA=new BigInteger(A.toString());
	return(AA);
    }



    public int[] pascalTriangle(int k) {
	if(k==0) {int[] a={1};return(a);}
	if(k==1) {int[] a={1,-1};return(a);}
	if(k==2) {int[] a={1,-2,1};return(a);}
	if(k==3) {int[] a={1,-3,3,-1};return(a);}
	if(k==4) {int[] a={1,-4,6,-4,1};return(a);}
	if(k==5) {int[] a={1,-5,10,-10,5,-1};return(a);}
	if(k==6) {int[] a={1,-6,15,-20,15,-6,1};return(a);}
	return(null);
    }

    public Polynomial compress(BigInteger[][][][][] B) {
	BigInteger Z=new BigInteger("0");
	Polynomial P=new Polynomial();
	int c=0;
	for(int i0=0;i0<7;++i0) {
	for(int i1=0;i1<7;++i1) {
	for(int i2=0;i2<7;++i2) {
	for(int i3=0;i3<7;++i3) {
	for(int i4=0;i4<7;++i4) {
	    int[] I={i0,i1,i2,i3,i4};
	    if(B[i0][i1][i2][i3][i4].compareTo(Z)!=0) {
		P.m[c]=new Monomial(B[i0][i1][i2][i3][i4],I);
		++c;
	    }
	}}}}}
	P.count=c;
	return(P);
    }


    public BigInteger[][][][][] initialize() {
	BigInteger[][][][][] B=new BigInteger[7][7][7][7][7];
	for(int i0=0;i0<7;++i0) {
	for(int i1=0;i1<7;++i1) {
	for(int i2=0;i2<7;++i2) {
	for(int i3=0;i3<7;++i3) {
	for(int i4=0;i4<7;++i4) {
	    B[i0][i1][i2][i3][i4]=new BigInteger("0");
	}}}}}
	return(B);
    }




    public Polynomial rotate(int k) {
	Polynomial P=new Polynomial(this);
	for(int i=0;i<count;++i) {
	    P.m[i]=m[i].rotate(k);
	}
	return(P);
    }

    public Polynomial subdivide(int choice) {
	int k=youngestIndex();
	return(subdivide(choice,k));
    }


    public Polynomial subdivide(int choice,int k) {
	if(choice==0) return(subdivide0(k));
	return(subdivide1(k));
    }


    public Polynomial subdivide0(int k) {
	Polynomial P=new Polynomial(this);
	P=P.rotate(-k);
	P=P.dilate();
	P=P.rotate(k);
	++P.age[k];
	P.marker=this.marker;
	return(P);
    }


    public Polynomial subdivide1(int k) {
	Polynomial P=new Polynomial(this);
	P=P.rotate(-k);	
	P=P.reflect();	
	P=P.dilate();
	P=P.rotate(k);	
	++P.age[k];
	P.marker=this.marker;
	return(P);
    }

    public int youngestIndex() {
	int min=100;
	int index=-1;
	for(int i=0;i<5;++i) {
	    if(min>age[i]) {
		min=age[i];
		index=i;
	    }
	}
	return(index);
    }



    /**Positive Dominance*/

    public boolean isPositiveDominant() {
	BigInteger Z=new BigInteger("0");
	BigInteger SUM=new BigInteger("0");
	int[] E=exponentLimit();
	for(int i0=0;i0<=E[0];++i0) {
	for(int i1=0;i1<=E[1];++i1) {
	for(int i2=0;i2<=E[2];++i2) {
	for(int i3=0;i3<=E[3];++i3) {
	for(int i4=0;i4<=E[4];++i4) {
        int[] I={i0,i1,i2,i3,i4};
	SUM=new BigInteger("0");
	    for(int j=0;j<count;++j) {
		boolean test=isDominated(m[j].e,I);
		if(test==true) {
		    SUM=SUM.add(m[j].c);
		}
	    }
            if(SUM.compareTo(Z)==-1) return(false);
	}}}}}
	return(true);
    }





    public static boolean isDominated(int[] e,int[] I) {
	for(int i=0;i<5;++i) if(e[i]>I[i]) return(false);
	return(true);
    }

    public BigInteger maxTerm() {
	BigInteger max=new BigInteger("0");
	for(int i=0;i<count;++i) {
	    BigInteger c1=new BigInteger(m[i].c.toString());
	    BigInteger c2=c1.negate();
	    if(max.compareTo(c1)==-1) max=c1;
	    if(max.compareTo(c2)==-1) max=c2;
	}
	return(max);
    }


    /**printouts*/
    public void print() {
	for(int i=0;i<count;++i) m[i].println();
    }

    public void printStats() {
	System.out.println("polynomial stats");
	System.out.println("#terms "+count);
	BigInteger max=maxTerm();
	System.out.println("max term "+max.toString());
	System.out.print("age   ");
	for(int i=0;i<5;++i) System.out.print(age[i]+" ");
	System.out.println("");
	int[] a=this.exponentLimit();
	System.out.print("exp limit   ");
	for(int i=0;i<5;++i) System.out.print(a[i]+" ");
	System.out.println("");
    }

    public void printAge() {
	System.out.print("age   ");
	for(int i=0;i<5;++i) System.out.print(age[i]+" ");
    }



    /**This are dummy routines used to debug the subdivision algorithm*/

    public boolean isPositiveDominantDummy() {
	if(age[0]>2) return(true);
	return(false);
    }

    public Polynomial subdivideDummy(int choice) {
	int k=youngestIndex();
	Polynomial P=new Polynomial(this);
	++P.age[k];
	return(P);
    }

}