import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class PositiveDominance implements Runnable {
    boolean HALT;
    PictureCanvas P;
    double TIME1,TIME2,VOLUME,TOTAL,TIME_MEMORY;
    Polynomial[] LIST;
    int STEPS,STEPS_MEMORY,COUNT_MEMORY;
    int[] MARKER=new int[2];


    public void run() {
	P.CM.clear();
	VOLUME=0;
	COUNT_MEMORY=0;
	LIST=initialList();
	HALT=false;
        TIME1=System.currentTimeMillis();
	TIME_MEMORY=TIME1;
	STEPS_MEMORY=0;
	int count=0;
	while((HALT==false)&&(LIST.length>0)) { 
            ++count;
	    int n=LIST.length; 
            STEPS=count;
	    recognizeSpecial(n);
	    LIST=step(LIST);
	    sendState();
	    P.repaint();
	} 
	sendState();
	printFinal();
	if(VOLUME>TOTAL-.00000001) System.out.println("QED");
	else System.out.println("calculation aborted");
	HALT=true; 
        P.repaint();
    }


    public Polynomial[] initialList() {
      Polynomial[] LIST0=new Polynomial[28];
      int count=0;
      int mode=P.ACTION.mode;

      if(mode==1) {
	for(int i=0;i<14;++i) {
	    if(P.SIMPLEX4.on[i]==1) {
		LIST0[count]=new Polynomial(DataCube.main(4,i));
        	LIST0[count].marker[0]=0;
		LIST0[count].marker[1]=i;
	       ++count;
	    }
	}

	for(int i=0;i<14;++i) {
	    if(P.SIMPLEX6.on[i]==1) {
		LIST0[count]=new Polynomial(DataCube.main(6,i));
		LIST0[count].marker[0]=1;
		LIST0[count].marker[1]=i;
	       ++count;
	    }
	}
      }

      if(mode==2) {
	for(int i=0;i<2;++i) {
	    if(P.SIMPLEX1.on[i]==1) {
		LIST0[count]=new Polynomial(DataCube.main(1,i));
        	LIST0[count].marker[0]=0;
		LIST0[count].marker[1]=i;
	       ++count;
	    }
	}
      }


	Polynomial[] LIST=new Polynomial[count];
	for(int i=0;i<count;++i) {
            LIST[i]=new Polynomial(LIST0[count-i-1]);
	}
	TOTAL=count;
	return(LIST);
    }

    public void sendState() { 
       int n=LIST.length;
         TIME2=System.currentTimeMillis();
         P.CM.TIME=TIME2-TIME1;
         P.CM.TIME2=TIME2-TIME_MEMORY;
         if(n>0) P.CM.AGE=LIST[n-1].age;
         P.CM.VOLUME=VOLUME;
         P.CM.TOTAL=TOTAL;
         P.CM.STEPS=STEPS;
         P.CM.STEPS2=STEPS-STEPS_MEMORY;
    }


    public void recognizeSpecial(int n) {
	double v=volume(LIST[LIST.length-1]);
	if((STEPS>1)&&(v==1)) {  
	    int a=MARKER[0];
	    int b=MARKER[1];
	    int[] A=convertTime(TIME2-TIME_MEMORY);
	    int steps=STEPS-STEPS_MEMORY;
	    P.CM.STEPS_MEMORY[a][b]=steps-1;
	    P.CM.MIN_MEMORY[a][b]=A[0];
	    P.CM.SEC_MEMORY[a][b]=A[1];
            TIME_MEMORY=TIME2;
	    STEPS_MEMORY=STEPS-1;
	}
    }

    public void printFinal() {
        int[] A=convertTime(TIME2-TIME_MEMORY);
        int steps=STEPS-STEPS_MEMORY+1; 
	int a=MARKER[0];
	int b=MARKER[1];
        P.CM.STEPS_MEMORY[a][b]=steps-1;
	P.CM.MIN_MEMORY[a][b]=A[0];
	P.CM.SEC_MEMORY[a][b]=A[1];
	P.CM.MARKER[0]=-1;
    }



    public static int[] convertTime(double t) {
	double u1=t/1000;  //seconds
	double u2=Math.floor(u1/60); //minutes
	double u3=u1-60*u2;  
	int a=(int)(u2);
	int b=(int)(u3);
	int[] A={a,b};
	return(A);
    }

    public PositiveDominance() {
	HALT=true;
    }

    public PositiveDominance(PictureCanvas PP) {
	HALT=true;
	this.P=PP;
    }


    public Polynomial[] step(Polynomial[] LIST0) {
	int last=LIST0.length-1;
	Polynomial Q=new Polynomial(LIST0[last]);
	MARKER[0]=Q.marker[0];
	MARKER[1]=Q.marker[1];
	P.CM.MARKER[0]=MARKER[0];
	P.CM.MARKER[1]=MARKER[1];
	P.repaint();

	boolean test=Q.isPositiveDominant();
	if(test==true) {
	    Polynomial[] LIST1=new Polynomial[last];
	    for(int i=0;i<last;++i) LIST1[i]=new Polynomial(LIST0[i]);
	    VOLUME=VOLUME+volume(Q);
	    return(LIST1);
	}

	Polynomial[] LIST1=new Polynomial[last+2];
	for(int i=0;i<last;++i) LIST1[i]=new Polynomial(LIST0[i]);
	LIST1[last+0]=Q.subdivide(0);
	LIST1[last+1]=Q.subdivide(1);
	return(LIST1);
    }

    public double volume(Polynomial Q) {
	double x=1;
	for(int i=0;i<5;++i) x=x*Math.pow(.5,Q.age[i]);
	return(x);
    }



}