import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

  
public class Simplex5 {

    public static double volume(double[][] a) {
	Matrix M=new Matrix();
	for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
		M.a[i][j]=a[i][j]-a[5][j];
	    }
	}
	return(M.det());
    }

    public static double[][] swap(double[][] a,double[] b,int k) {
	double[][] e=new double[6][5];
	for(int i=0;i<6;++i) {
	    for(int j=0;j<5;++j) {
		e[i][j]=a[i][j];
		if(i==k) e[i][j]=b[j];
	    }
	}
	return(e);
    }

    public static int[] characteristic(double[][] a,double[] b) {
	int[] n=new int[6];
	for(int i=0;i<6;++i) {
	    double[][] c=swap(a,b,i);
	    double v=volume(c);
	    n[i]=sign(v);
	}
	return(n);
    }

    public static int[] characteristic(double[][] a) {
	double[] b=center(a);
	int[] n=characteristic(a,b);
	return(n);
    }

    public static boolean inside(double[][] a,double[] b) {
	double vol=Math.abs(volume(a));
	if(vol<.01) return(false);
	int[] m=characteristic(a,b);
	int[] n=characteristic(a);
	for(int i=0;i<6;++i) {
	    if(m[i]*n[i]==-1) return(false);
	}
	return(true);
    }


    /**center of tetrahedron*/

    public static double[] center(double[][] a) {
	double[] b=new double[5];
	for(int i=0;i<6;++i) {
	    for(int j=0;j<5;++j) {
		b[j]=b[j]+a[i][j];
	    }
	}
	for(int i=0;i<5;++i) b[i]=b[i]/6;
	return(b);
    }


    /**centroid of jth edge*/
    public static double[] center(double[][] a,int j) {
	double[] c={0,0,0,0,0};
	double[][] b=swap(a,c,j);
	double[] t=center(b);
	for(int i=0;i<5;++i) t[i]=6.0*t[i]/5.0;
	return(t);
    }

    /**slightly outside the center of the jth face*/

    public static double[] pastCenter(double[][] a,int j) {
	double[] t1=center(a);
	double[] t2=center(a,j);
	double[] u=new double[5];
	for(int i=0;i<5;++i) {
	    u[i]=-.0000001*t1[i]+(1.0000001)*t2[i];
	}
	return(u);
    }

    /**tests whether the kth face of a is abuts b.  When this
       is applied, the program will know that the kth face of a
       is also a face of b*/

    public static boolean abut(double[][] a,int k,double[][] b) {
	double[] t=pastCenter(a,k);
	return(inside(b,t));
    }






    public static int sign(double d) {
	if(d<0) return(-1);
	if(d==0) return(0);
	return(1);
    }



}






