import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors up to length 20*/


public class Vector {
    double[] x=new double[20];
    int size;

    /**constructors*/

    public Vector() {
	size=3;
    }

    public Vector(double a0,double a1,double a2) {
	size=3;
	x[0]=a0;
	x[1]=a1;
	x[2]=a2;
    }

    public Vector(double[] X) {
	size=X.length;
	for(int i=0;i<size;++i) x[i]=X[i];
    }

    public Vector(Vector V) {
	size=V.size;
	for(int i=0;i<size;++i) x[i]=V.x[i];
    }

    /**Here are some general routines**/


    public static Vector plus(Vector v1,Vector v2) {
	if(v1.size!=v2.size) return(null);
	Vector w=new Vector();
	for(int i=0;i<v1.size;++i) w.x[i]=v1.x[i]+v2.x[i];
	w.size=v1.size;
	return(w);
    }

    public static Vector minus(Vector v1,Vector v2) {
	if(v1.size!=v2.size) return(null);
	Vector w=new Vector();
	for(int i=0;i<v1.size;++i) w.x[i]=v1.x[i]-v2.x[i];
	w.size=v1.size;
	return(w);
    }

    public static Vector scale(double r,Vector v) {
	Vector w=new Vector();
	for(int i=0;i<v.size;++i) w.x[i]=r*v.x[i];
	w.size=v.size;
	return(w);
    }

    public Vector scale(double r) {
	return(scale(r,this));
    }

    public static double dot(Vector v,Vector w) {
	int s=v.size;
	double d=0;
	for(int i=0;i<s;++i) d=d+v.x[i]*w.x[i];
	return(d);
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }

    public static double dist(Vector v,Vector w) {
	Vector x=Vector.minus(v,w);
	return(x.norm());
    }


    public double norm() {
	return(Math.sqrt(dot(this,this)));
    }

    /**random*/

    public static Vector random(int s) {
	Vector V=new Vector();
	V.size=s;
	for(int i=0;i<s;++i) V.x[i]=Math.random();
	return(V);
    }



}




