import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;




public class ColorGenerator {

    public static Color COL(int k,int alpha) {
       Color C=COL(k);
       return makeTransparent(C,alpha);
    }

    public static Color makeTransparent(Color C,int alpha) {
	    int rr=C.getRed();
	    int gg=C.getGreen();
	    int bb=C.getBlue();
	    if(alpha<0) alpha=0;
	    if(alpha>255) alpha=255;
	    Color C2=new Color(rr,gg,bb,alpha);
	    return C2;
    }



    public static Color COL(int n0) {
	int n=n0%30;
	String[] C={"#0ee","#46f","#0f0","#f5f","#6ff",
           "#f68","#6bf","#48b","#a0a","#f70",
           "#c03","#40b","#0d0","#f0a","#ff0",
           "#f90","#609","#090","#808","#0f6",
           "#a00","#5af","#0a0","#a0a","#0aa",
	   "#906","#4f6","#0a5","#949","#499"};
	String S=C[n];
	String R=S.substring(1,2);
	String G=S.substring(2,3);
	String B=S.substring(3,4);
	int r=convert(R);
	int g=convert(G);
	int b=convert(B);
	Color X=new Color(r,g,b);
	return X;
    }

    public static int convert(String S) {
	String[] u={"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"};
	int index=0;
	for(int i=0;i<16;++i) {
	    if(S.equals(u[i])==true) index=i;
	}
	int t=index*16+15;
	return t;
    }

}


    
