import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    int[] tag=new int[2];
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
	this.tag[0]=z.tag[0];
	this.tag[1]=z.tag[1];
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    
    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    
    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    
    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }

    public Complex conjugate() {
	return conjugate(this);
    }

    public static double dist(Complex z,Complex w) {
	Complex a=Complex.minus(z,w);
	return(a.norm());
    }
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public static Complex unit(Complex z) {
	double d=z.norm();
	return new Complex(z.x/d,z.y/d);
    }

    public Complex unit() {
	return unit(this);
    }
    

    public Complex scale(double d) {
	return new Complex(d*this.x,d*this.y);
    }

    public static boolean isBetween(Complex a,Complex b1,Complex b2) {
	double d1=dist(a,b1);
	double d2=dist(a,b2);
	if(d1+d2<dist(b1,b2)+.0000000000001) return true;
	return false;
    }

    public static double area(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	double a=Math.abs(z[4].y);
	return(a);
    }

    public static double distanceToLine(Complex w,Complex z1,Complex z2) {
	double a=area(w,z1,z2);
	double b=dist(z1,z2);
	if(a<0) a=-a;
	a=a/b;
	return(a);
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }

    public static Complex projectToLine(Complex w,Complex z1,Complex z2) {
	Complex v1=new Complex(w);
	v1=Complex.minus(v1,z1);
	Complex a=Complex.minus(z2,z1);
	v1=Complex.divide(v1,a);
	v1.y=0;
	v1=Complex.times(v1,a);
	v1=Complex.plus(v1,z1);
	return(v1);
    }

}

