import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;
import java.io.File;
import javax.imageio.ImageIO;

public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener  {
    Manager M;
    ListenSquare MAP;
    ControlPanel DISPLAY,FIT,STUDY,VORONOI,AFMAP;
    EnhancedSlider TRANS0,TRANS1;
    PopupManager POP;
    String[] MESSAGE=new String[10];
    ListenSquare[] INFO=new ListenSquare[20];
    SelectInteger VTX;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 MAP=new ListenSquare(20,130,50,40);
	 TRANS0=new EnhancedSlider(4,190,540,47,200,new Color(80,150,255),"voronoi transparency");
	 TRANS1=new EnhancedSlider(4,240,540,47,400,new Color(50,100,255),"city transparency");

	 MESSAGE[0]=".65";
	 MESSAGE[1]=".25";
	 MESSAGE[2]="state 1";
	 MESSAGE[3]="city 7";
	 MESSAGE[4]="zip 834";
	 MESSAGE[5]="------";
	 MESSAGE[6]="------";

	 setPanels();
	 setInfo();
     }

    public void setInfo() {
	
        INFO[0]=new ListenSquare(93,20,12,12);
        INFO[2]=new ListenSquare(93,35,12,12);
        INFO[3]=new ListenSquare(93,50,12,12);
	INFO[12]=new ListenSquare(203,165,12,12);

	INFO[1]=new ListenSquare(203,80,12,12);
	INFO[4]=new ListenSquare(203,20,12,12);
	INFO[5]=new ListenSquare(203,35,12,12);
	INFO[6]=new ListenSquare(203,135,12,12);
	INFO[7]=new ListenSquare(203,150,12,12);
	INFO[8]=new ListenSquare(203,65,12,12);
	INFO[9]=new ListenSquare(93,65,12,12);
	INFO[10]=new ListenSquare(93,80,12,12);
	
	INFO[11]=new ListenSquare(203,165,12,12);
	INFO[12]=new ListenSquare(93,95,12,12);

	INFO[13]=new ListenSquare(203,50,12,12);
	INFO[14]=new ListenSquare(203,95,12,12);
	
	INFO[15]=new ListenSquare(8,130,12,12);
	INFO[16]=new ListenSquare(533,0,12,12);
    }
    
    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};

	String[] DisplayString={"central face","states","cities","curve marker","state study","city divider","domains"};
	int[] DisplayState={0,0,1,1,1,0,0};
        DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,6);


	String[] VoronoiString={"voronoi10","voronoi6","vertex labels","triple point","plan","asterisk","voronoi"};
	int[] VoronoiState={1,0,0,0,0,0,0};
        VORONOI=new ControlPanel(C0,VoronoiString,VoronoiState,6);


	String[] AfmapString={"the map","map direction","rhombus map","AF map"};
	int[] AfmapState={1,0,0};
        AFMAP=new ControlPanel(C0,AfmapString,AfmapState,3);

	
	String[] FitString={"none","plan","central face","state","curve marker","fit"};
	int[] FitState={1,0,0,0,0};
        FIT=new ControlPanel(C0,FitString,FitState,5);


	String[] StudyString={"voronoi","map","hybrid","states","study"};
	int[] StudyState={1,1,1,1};
        STUDY=new ControlPanel(C0,StudyString,StudyState,4);

    }

    public int getTrans(int k) {
	double t=TRANS0.getValue();
	if(k==1) t=TRANS1.getValue();
	int a=(int)(255*t);
	return a;
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawMessage(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(220,160,220));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,16));
	g.drawString("3 button mouse:",330,130);
	g.drawString("use keys ZXC",330,150);
    }


    public void drawMessage(Graphics2D g) {
	g.setColor(new Color(130,0,150));
	g.fillRect(320,0,225,80);
	g.setColor(Color.white);
	g.drawRect(320,0,225,80);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	for(int i=0;i<3;++i) g.drawString(MESSAGE[i],330,23+25*i);
	g.drawString(MESSAGE[3],405,73);
	g.drawString(MESSAGE[4],465,73);
    }

    

    public void drawControls(Graphics2D g) {
	MAP.render(g,"AF",30,2,new Color(0,0,180));
	DISPLAY.render(g,0,0,105);
	VORONOI.render(g,110,0,105);
	AFMAP.render(g,110,115,105);
	FIT.render(g,220,0,90);
	STUDY.render(g,220,100,90);
	TRANS0.render(g);
	TRANS1.render(g);
	POP.render(g);
	for(int i=0;i<17;++i) INFO[i].infoRender(g);
    }

    
    public void documentStuff(Point X) {
	int t=0;
	t=DISPLAY.getValue(X);
	if(t==20) DocumentControl.display(M.D);
	t=VORONOI.getValue(X);
	if(t==20) DocumentControl.voronoi(M.D);
	t=AFMAP.getValue(X);
	if(t==20) DocumentControl.AFmap(M.D);
	t=FIT.getValue(X);
	if(t==20) DocumentControl.fit(M.D);
	t=STUDY.getValue(X);
	if(t==20) DocumentControl.study(M.D);
	
	if(INFO[0].inside(X)==1) DocumentControl.central(M.D);
	if(INFO[1].inside(X)==1) DocumentControl.plan(M.D);
	if(INFO[2].inside(X)==1) DocumentControl.states(M.D);
	if(INFO[3].inside(X)==1) DocumentControl.cities(M.D);
	if(INFO[4].inside(X)==1) DocumentControl.voronoi10(M.D);
	if(INFO[5].inside(X)==1) DocumentControl.voronoi6(M.D);
	if(INFO[6].inside(X)==1) DocumentControl.AF(M.D);
	if(INFO[7].inside(X)==1) DocumentControl.AFDirection(M.D);
	if(INFO[8].inside(X)==1) DocumentControl.triple(M.D);
	if(INFO[9].inside(X)==1) DocumentControl.markers(M.D);
	if(INFO[10].inside(X)==1) DocumentControl.stateStudy(M.D);
	if(INFO[11].inside(X)==1) DocumentControl.mapStudy(M.D);
	if(INFO[12].inside(X)==1) DocumentControl.cityDivider(M.D);
	if(INFO[13].inside(X)==1) DocumentControl.vertexLabels(M.D);
	if(INFO[14].inside(X)==1) DocumentControl.asterisk(M.D);
	if(INFO[15].inside(X)==1) DocumentControl.map(M.D);
	if(INFO[16].inside(X)==1) DocumentControl.message(M.D);
    }

    public void study(Point X) {
	int t=STUDY.getValue(X);
	if(t!=-1) clearView();
	if(t==0) setVoronoi();
	if(t==1) setMap();
	if(t==2) setHybrid();
	if(t==3) setStates();
    }

    public void setVoronoi() {
	int[] s={0,1,1,0,1,0};
	for(int i=0;i<6;++i) VORONOI.L[i].on=s[i];
	TRANS0.forceValue(.5);
	M.P.scaleNicely(1);
	FIT.forceMode(0);
    }
    
    public void setMap() {
	int[] s={1,1,1};
	for(int i=0;i<3;++i) AFMAP.L[i].on=s[i];
	DISPLAY.L[1].on=1;
	DISPLAY.L[2].on=1;
	TRANS1.forceValue(1);
	M.P.scaleNicely(2);
	FIT.forceMode(0);
    }
    
    public void setHybrid() {
	DISPLAY.L[2].on=1;
	VORONOI.L[1].on=1;
	AFMAP.L[0].on=1;
	AFMAP.L[1].on=1;
	TRANS1.forceValue(.5);
	TRANS1.forceValue(.5);
	M.P.scaleNicely(3);
	FIT.forceMode(0);
    }
    public void setStates() {
        DISPLAY.L[1].on=1;
	DISPLAY.L[4].on=1;
	TRANS1.forceValue(1);
	M.P.scaleNicely(2);
	FIT.forceMode(0);
    }

    public void clearView() {
	for(int i=0;i<6;++i) DISPLAY.L[i].on=0;
	for(int i=0;i<6;++i) VORONOI.L[i].on=0;
	for(int i=0;i<3;++i) AFMAP.L[i].on=0;
    }
    


  public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e);
       VORONOI.toggle(J.X);
       DISPLAY.toggle(J.X);
       AFMAP.toggle(J.X);
       FIT.switchMode(J.X);
       study(J.X);
       TRANS0.configure(J.X);
       TRANS1.configure(J.X);
       POP.process(J.X);
       if(MAP.inside(J.X)==1) M.P.setSource(M.P.FARPOINT);
       documentStuff(J.X);
       repaint();
       M.P.repaint();
       doTest();
   }

        
   public void mouseMoved(MouseEvent e) {
   }

   public void mousePressed(MouseEvent e) {
       MouseData J=MouseData.process(e);
       TRANS0.activate(J.X);
       TRANS1.activate(J.X);
   }

    
    public void mouseDragged(MouseEvent e) {
       MouseData J=MouseData.process(e);
       TRANS0.configure(J.X);
       TRANS1.configure(J.X);
       M.P.repaint();
       repaint();
    }

    
     public void mouseReleased(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}

    public void doTest() {}

}

