import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class DecagonCities {

    public static Path2D.Double[] main() {
	Path2D.Double[] p=new Path2D.Double[60];
	for(int i=0;i<60;++i) {
	    Complex[] Z=zone(i,100);
	    PolygonWrapper X=new PolygonWrapper(Z.length, Z);
	    p[i]=X.toPath();
	}
	return p;
    }

    public static Complex[] zone(int k,int N) {
	int k1=k%12;
	int k2=(k-k1)/12;
	Complex[] Z=zone5(k1,N);
	Z=rotate(k2,Z);
	return Z;
    }

    public static Complex[] zone5(int k,int N) {
	if(k<6) return zone50(k,N);
	return reflect(zone50(k-6,N));
    }
    
    public static Complex[] zone50(int k,int N) {
	if(k==0) return zone914(N);
	if(k==3) return zone946(N);
	if(k==2) return zone894(N);
	if(k==1) return zone934(N);
	if(k==4) return zone146(N);
	if(k==5) return zone916(N);
	return null;
    }

    public static Complex[] zone914(int N) {
	Complex[] Z1=Formulas.curve(1,N);
	Complex[] Z2=Formulas.curve(2,N/5);
	Complex[] Z3=Formulas.curve(5,N);
	Complex[] Z4=join(Z1,Z2);
	Complex[] Z5=join(Z4,Z3);
	Z5=fix(Z5);
	return Z5;
    }

    public static Complex[] zone946(int N) {
	Complex[] Z1=Formulas.curve(1,N);
	Complex[] Z2=Formulas.curve(4,N);
	Complex[] Z=join(Z1,reverse(Z2));
	Z=fix(Z);
	return Z;
    }
    
    public static Complex[] zone934(int N) {
	Complex[] Z1=Formulas.curve(3,N);
	Complex[] Z2=Formulas.curve(5,N);
	Complex[] Z=join(reverse(Z1),Z2);
	Z=fix(Z);
	return Z;
    }
    public static Complex[] zone894(int N) {
	Complex[] Z1=Formulas.curve(4,N);
	Complex[] Z2=Formulas.curve(2,N/5);
	Complex[] Z3=Formulas.curve(3,N);
	Complex[] Z4=join(Z1,Z2);
	Complex[] Z5=join(Z4,Z3);
	Z5=fix(Z5);
	return Z5;
    }
    
    public static Complex[] zone146(int N) {
	Complex w=DecagonCombinatorics.zonePoint(3);
	Complex[] Z1={w.conjugate()};
	Complex[] Z2=Formulas.curve(0,N);
	for(int i=0;i<Z2.length;++i) Z2[i]=Z2[i].conjugate();
	Z2=fix(Z2);
	Complex[] Z=join(Z1,Z2);
	return Z;
    }
    
    public static Complex[] zone916(int N) {
	Complex w=new Complex(0,0);
	Complex[] Z1={w};
	Complex[] Z2=Formulas.curve(0,N);
	for(int i=0;i<Z2.length;++i) Z2[i]=Z2[i].conjugate();
	Z2=fix(Z2);
	Complex[] Z=join(Z1,Z2);
	return Z;
    }

    public static Complex[] reverse(Complex[] a) {
	int N=a.length;
	Complex[] b=new Complex[N];
	for(int i=0;i<N;++i) b[i]=new Complex(a[N-1-i]);
	return b;
    }

    public static Complex[] join(Complex[] a,Complex[] b) {
	Complex[] c=new Complex[a.length+b.length];
	int count=0;
	for(int i=0;i<a.length;++i) {
	    c[count]=new Complex(a[i]);
	    ++count;
	}
	for(int i=0;i<b.length;++i) {
	    c[count]=new Complex(b[i]);
	    ++count;
	}
	return c;
    }

    public static Complex[] fix(Complex[] Z) {
	Complex u=Decagon.rootOfUnity5(1);
	Complex[] W=new Complex[Z.length];
	for(int i=0;i<Z.length;++i) W[i]=Complex.times(u,Z[i].conjugate());
	return W;
    }
    

    public static Complex[] reflect(Complex[] Z) {
	Complex[] W=new Complex[Z.length];
	for(int i=0;i<Z.length;++i) W[i]=reflect(Z[i]);
	return W;
    }
    

    public static Complex reflect(Complex z) {
	Complex z2=Complex.times(z.conjugate(),Decagon.rootOfUnity5(1));
	return z2;
    }

    public static Complex[] rotate(int k,Complex[] Z) {
	Complex[] W=new Complex[Z.length];
	for(int i=0;i<Z.length;++i) W[i]=rotate(k,Z[i]);
	return W;
    }
    

    public static Complex rotate(int k,Complex z) {
	double a=2*Math.PI/5;
	double c=Math.cos(k*a);
	double s=Math.sin(k*a);
	Complex w=new Complex(c,s);
	Complex z2=Complex.times(z,w);
	return z2;
    }
}

