import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void display(DocumentCanvas D) {
	String S="domain display";

	S=S+"\n\nThis control panel toggles the main displays on the picture window which have to do with the partition of the pentagon into dynamically meaningful partitions. Click on the question boxes next to the items to find out what they mean.";

	sendTo(D,S);
    }
    

    public static void voronoi(DocumentCanvas D) {
	String S="voronoi display";

	S=S+"\n\nThis control panel toggles the main displays on the picture window which have to do with the voronoi decompositions which appear in our constructions. Click on the question boxes next to the items to find out what they mean.";

	sendTo(D,S);
    }

    public static void AFmap(DocumentCanvas D) {
	String S="AF map display";

	S=S+"\n\nThis control panel toggles the main displays on the picture window which have to do with the AF map. Click on the question boxes next to the items to find out what they mean.";

	sendTo(D,S);
    }


    

    
    public static void message(DocumentCanvas D) {
	String S="messages";

	S=S+"\n\nThese messages here are mostly for the purposes of debugging.  Here is a description of what these numbers mean:";
	S=S+"\n\nThe first number is the X coordinate of the current input point.  Call this point p";
	S=S+"\n\n The second number is the Y coordinate of p.";
	S=S+"\n\n The third number names the state containing p.  The numbering of the states is not really canonical.";
	S=S+"\n\n The fourth number names the city containing p.  The numbering of the cities is not really canonical";
	S=S+"\n\nThe point AF(p) is a vertex of the cut locus C(p) of the point A(p).  The fifth number, which we call the zip code, names this vertex.    The cut locus C(p) is determined by the Voronoi decomposition of a certain 10-gon.  The relevant cut locus vertex generically lies in exactly 3 Voronoi cells.  The zip code gives the indices of the cells.  Our code works very much like a real life zip code:  The first two digits only depend on the state and the third digit depends on the city.  We point out two differences, however.  If we switch the first two digits we are referring to the same vertex.  Thus 619 nd 169 are the same vertex. Also, several cities can have the same zip code.  ";

	sendTo(D,S);
    }

    public static void fit(DocumentCanvas D) {
	String S="fit";

	S=S+"\n\nThis control panel controls the scaling in the picture window.  There are 5 options:";
	S=S+"\n\n none:  With this option you scale the window manually using mouse buttons 1 or 3.  If you do not have a 3-button mouse you can use the keys Z and C.";

	S=S+"\n\nplan:  This option  scales the window so that the big dodecahedral fits in the screen.";

	S=S+"\n\ncentral face:  This option scales the window so that the pentagon, one face of the dodecahedron fits in the screen.";
	
	S=S+"\n\nstate:  The pentagon is divided into 15 states, each one a quadrilateral.  This option scales the picture so that the current state, meaning the one which contains the input point, fits in the whole screen.";

	S=S+"\n\ncurve marker:  This feature only works if the FORMULA window is open.  The pentagon is tiled by 60 cities.  The edges of these cities, which do not lie in the state edges, are defined by algebraic curves. Modulo symmetry there are 6 such curves.   With this option, you can scale the picture to get an extreme close up of the selected curve.  The purpose of this option is so that you can watch the corresponding polynomial change signs as you drag the mouse back and forth over the curve.";

	sendTo(D,S);
    }

    
    public static void study(DocumentCanvas D) {
	String S="study";
 
	S=S+"\n\nThis control panel has 4 preset options which let you take a look more carefully at the main constructions that go into this program.";

	S=S+"\n\nvoronoi: you study the construction of the big 10-gon and the associated Voronoi decomposition.  The construction is based on a certain development of the dodecahedron into the plane.  The plan shows this development.  The 10 outermost pentagons are colored in a way that is canonical with respect to the coloring of the central pentagon.  Next, we start with an initial point p in the central pentagon.  We then place points p0,...,p9 in the outer pentagons in the plan so that the color-preserving isometry from the central piece to the Kth outer puece carries p to qK.   These are the vertices of the 10-gon that controls the cut locus C(p) of the point A(p).";
	
	S=S+"\n\nmap:  removes the cut locus picture and lets you focus on the the states and the cities.  The map AF varies analytically within each city, and you can see this by dragging the mouse around over a city and watching how AF changes.";

	S=S+"\n\nhybrid: shows a closeup of how the cut locus and the map AF interact, within one state.";
	
	S=S+"\n\nstates: This shows the geometric construction of the states.";

	sendTo(D,S);
    }


    public static void map(DocumentCanvas D) {
	String S="AF button";

	S=S+"\n\nWhen you press this button, it does the AF map.  The AF map is represented by a thick white line segment. One end of the segment is p and the other end is AF(p).   When you press the button, you replace p by AF(p).  If you press the button repeatedly you can see the action of AF.  A few minutes playing with this will convince you that the omega limit set of AF is the union of state boundaries.";

	sendTo(D,S);
    }


    public static void vertexLabels(DocumentCanvas D) {
	String S="vertex labels";

	S=S+"\n\nThis turns on the numerical labels of the decagon and the hexagons.  The points of the decagon are p0,...,p9 and the labels give the indices of these points.  The hexagon labels do the same thing.";

	sendTo(D,S);
    }
    
    public static void asterisk(DocumentCanvas D) {
	String S="asterisk";

	S=S+"\n\nEvery pair of vertices of the big decagon determines a bisector.  Call two vertices of the decagon antipodal if their indices differ by 5.  This p1 and p6 are antipodal. It turns out that the 5 bisectors associated to antipodal pairs of points all meet at the point p, on which the decagon is based.  Moreover, they are parallel to the ten 10th roots of unity.  They make a perfect asterisk centered at p.  This button shows these bisectors.";

	sendTo(D,S);
    }

    public static void cityDivider(DocumentCanvas D) {
	String S="city dividers";

	S=S+"\n\nDuring the course of our proof in the paper, we define some triangular domains which confine variuos of the cities. We do this because we don't want to deal with the curvilinear cities directly.  For instance, if we want to prove that some polynomial is positive on some city, we prove the stronger result that the polynomial is positive on the triangular domain that contains the city.";

	sendTo(D,S);
    }

    public static void central(DocumentCanvas D) {
	String S="central";

	S=S+"\n\nOur domain for AF, the composition of the farpoint map with the antipodal map, is one face of the dodecahedron.  This feature toggles the display of the face.  When many other features are on, you can barely see this face.  However, if you turn off all the other features, you will see it.  It is not a priori obvious that AP preserves this face, but in fact it does.";

	sendTo(D,S);
    }


    public static void plan(DocumentCanvas D) {
	String S="plan";

	S=S+"\n\nOne of the two main constructions in this program is the cut locus on the dodecahedron with respect to some point on it.  We compute the cut locus by first defining a certain convex 10-gon and then taking its Voronoi decomposition.   This feature gives some understand of how this 10-gon is constructed. We first develop the dodecahedra out into the plane 4-steps in all directions, creating what we call the plan.  We then take symmetrically located points in each of the 10 outermost pentagons in the plan.  These extreme points are the vertices of the 10-gon.";

	sendTo(D,S);
    }


    public static void states(DocumentCanvas D) {
	String S="states";

	S=S+"\n\nThe pentagon domain is divided into 15 quadrilaterals which we call STATES.  With this option on, you see the state which contains the current input point.  There is an inner cluster of 5 states and an outer cluster of 10 states.  The union of the 5 inner states is a small pentagon which is obtained from the large pentagon by doing the pentagram map!   The remaining 10 states tile the complementary region.  Their edges either lie in the boundary of the big pentagon, the boundary of the little pentagon, or in lines of dihedral symmetry.";

	sendTo(D,S);
    }

    public static void cities(DocumentCanvas D) {
	String S="cities";

	S=S+"\n\nEach state is divided into 4 cities, and thus the whole pentagon domain is divided into 60 cities.  The map AF varies analytically within a city.  Likewise, the cut locus is structurally stable within each city.  This feature displays the cities.  The edges of a city, which do not lie in the edges of a state, are not line segments even though some of them appear to be so.  These new edges are the zero sets of certain polynomials of 2 variables.  Modulo symmetry there are 6 such edges.  If you open up the FORMULAS window you can see the equations for a representative collection of these 6 edges.";

	sendTo(D,S);
    }

    public static void voronoi10(DocumentCanvas D) {
	String S="voronoi10";

 	S=S+"\n\nOne of the two main constructions in this program is the cut locus on the dodecahedron with respect to some point on it.  We compute the cut locus by first defining a certain convex 10-gon and then taking its Voronoi decomposition.   This feature displays the 10-gon.  If you are displaying the 10-gon, you can change the transparency of it to get various views of how it interacts with the states and cities.";

	sendTo(D,S);
    }

    public static void voronoi6(DocumentCanvas D) {
	String S="voronoi6";

 	S=S+"\n\nOne of the two main constructions in this program is the cut locus on the dodecahedron with respect to some point on it.  We compute the cut locus by first defining a certain convex 10-gon and then taking its Voronoi decomposition.  Within each state, the map AF is determined by a certain collection of 6 out of 10 of the vertex.  So, we can also view AF as being determined by a certain collection of hexagons, one per city. This feature shows these hexagons.  If you superimpose the relevant 6-gon over the big 10-gon, you will see that the edges of the two Voronoi decompositions agree within each city.  This feature might be a bit confusing, so possibly it is best just to leave it off.";

	sendTo(D,S);
    }

    public static void AF(DocumentCanvas D) {
	String S="AF map";

 	S=S+"\n\nThis feature shows AF, the composition of the farthest point map with the antipodal map.  One end of the white line segment is the initial point p and the other end is AF(p).   This point is always a vertex of the cut locus C(p) of the dodecahedron with respect to A(p).";

	sendTo(D,S);
    }

    public static void AFDirection(DocumentCanvas D) {
	String S="AF direction";

 	S=S+"\n\nThis feature shows some additional structure of AF.  The line segment joining p to AF(p) is contained in a line which is perpendicular to one of the sides of the big pentagon.  This feature shows this line and the relevant pentagon side.  Each city is foliated by parallel line segments, perpendicular to the pentagon edge.  The restriction of AF to each of these line segments is a linear fractional transformation whose fixed point is contained in a state boundary.  In particular, the omega limit set of AF is the union of the state boundaries.";

	sendTo(D,S);
    }
    
    public static void triple(DocumentCanvas D) {
	String S="triple point";

 	S=S+"\n\nGiven p in the pentagon domain the point AF(p) is a vertex of the cut locus C(p) of A(p).  This vertex is generically a triple point of the Voronoi decomposition of the big 10-gon.  Thus, AF(p) is determined by a triple of vertices of the 10-gon. This feature displays the triangle which is the convex hull of these three vertices.  Note one interesting piece of geometric structure:  One edge of this triangle is perpendicular to the line joining p to AF(p).";
	sendTo(D,S);
    }

    public static void markers(DocumentCanvas D) {
	String S="curve markers";

	S=S+"\n\nThis feature works in tandem with the FORMULAS window. The edges of a city, which do not lie in the edges of a state, are not line segments even though some of them appear to be so.  These new edges are the zero sets of certain polynomials of 2 variables.  Modulo symmetry there are 6 such edges.  If you open up the FORMULAS window you can see the equations for a representative collection of these 6 edges. When you press one of the 6 buttons on the FORMULA window, a little yellow segment will appear in the picture window.  This segment will cross the edge which is associated to the selected polynomial.";

	sendTo(D,S);
    }
    
    public static void stateStudy(DocumentCanvas D) {
	String S="state study";

	S=S+"\n\nThis feature shows how the states are constructed. They are giving by a straight line construction involving the pentagram and the angle bisectors.";
	
	sendTo(D,S);
    }
    
    public static void mapStudy(DocumentCanvas D) {
	String S="map study";

	S=S+"\n\nThis feature shows how the map AF is constructed geometrically.  The map is defined by a triple (R,v,E), where R is a rhombus, v is a vertex of R and E is an edge of R that has v as an endpoint.  The construction of the map based on (R,v,E) is given as follows.";
	S=S+"\n\nGiven z1, let z2 be the point where the line (v,z1) intersects the diagonal of R opposite v. ";
	S=S+"\n\nLet L be the line parallel to E through z1.";
	S=S+"\n\nLet w be the vertex of R opposite v.";
	S=S+"\n\nLet z2 be the intersection of L with the line (w,z2).";
	S=S+"\n\nThe map carries z1 to z3.";
	S=S+"\n\nFor each of the 60 cities there is an associated triple like this, and there are a total of 40 distinct triples that arise. Altogether there are 40 different triples that arise.  These triples have two shapes, and the shapes are the same as the shapes of the rhombs that appear in the Penrose tiling.  The short diagonals of the fat rhombs have length 6sin(2\u03C0/5) and the short diagonals of the thin rhombs have length 3\u03D5, where \u03D5 is the golden ratio.  The sides and diagonals of these rhonbs are either parallel or perpendicular to the sides of the central pentagon, as they would be in the Penrose tiling.  If you turn on the plan feature you can see more geometric relationships between the rhomb and the central pentagon.";
	sendTo(D,S);
    }

}
