import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentFormula {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void basic(DocumentCanvas D) {
	String S="formula display";

	S=S+"\n\nThis window lets you see the formulas for various quantities associated to the AF map on the regular dodecahedron.  There are three kinds of formuas:";
	
	S=S+"\n\n1. curves: The pentagon domain is tiled by 60 curvilinear tiles which we call CITIES.  Each city is bounded by line segments and algebraic curves.  Modulo the dihedral symmetry of the pentagon, there are 6 such curves.  Each such curve is the zero set of a polynomial in two variables.  This window displays these polynomials in a grid fashion.  The square in position (i,j) contains a numerical code for the mononial corresponding to exponents (i,j).";
	
	S=S+"\n\n2. vertices: Recall that each city lies in a STATE.  Each city has some vertices which lie in the interior of the state that contains it.  Modulo symmetry, there are three such vertices.  This window also displays the formulas for 3 vertices.  We have chosen the the representative vertices to lie at the intersections of the curves we consider.  I will discuss the curves first and then the vertices.";

	S=S+"\n\n3. AF map:  This window also displays the formulas for AF.  These maps are piecewise birational, and in fact piecewise bi-quadratic.";

	sendTo(D,S);

    }




    public static void curve(DocumentCanvas D) {

	String S="curve formula display";

	S=S+"\n\nThe row of 6 squares allows you to specify one of the 6 polynomials, and the corresponding curve in the picture window.  When you click on one of the squares, the polynomial appears and the curve is marked by a yellow segment in the picture window (assuming that the 'curve marker' feature is turned on).  At the same time, a yellow 4 digit code appears.  Suppose that this code is 9413.  Then the zip codes of the two cities adjacent to the curve are 941 and 943.  The poly is negative in 941 and positive in 943.";
	
	S=S+"\n\nSuppose now that you are seeing a display of one of the polynomials. When you wave the mouse over a given square in the grid, the display in the black bar at the top shows the corresponding monomial.  The coefficient is given in two ways.  First, we give the floating point value.  Next, we give the exact value.  The exact value is an algebraic integer in a solvable degree 8 extension of Q.  Half the coefficients, corresponding to the pink squares, lie in one degree 4 extension of Q, and the other half, corresponding to blue squares, lie in another degree 4 extension.";

	S=S+"\n\nIf you play around with the picture canvas you will notice that there are pairs of cities that have the same zip codes.  For instance, the 941/946 interface occurs in two places.  One of the algebraic curves associated to this interface is a rotation of the algebraic curve associated to the function F1649.  In other words, a rotation of the zero arc for the function F1649 is the analytic continuation of the zero arc for the function F9461.   We could therefore have described our 6 special curves with just 5 equations.  It seemed simpler to just have all 6 equations even though technically there is some redundancy.";
	
	S=S+"\n\nIt is remarkable that many of the city boundaries look quite like line segments, but in fact they are the sero sets of these complicated polynomials. The most extreme case is the level set of F1649.  This curve really looks almost straight.";

	sendTo(D,S);
    }

    

    public static void vertex(DocumentCanvas D) {

	String S="vertex formula display";

	S=S+"\n\nThe row of 3 squares lets you select the city vertices.  When you click on one of these squares, you see either one or two polynomials displayed and also you see a yellow cross mark the corresponding vertex in the picture window (assuming the 'curve marker' feature is turned on).   Call the vertex (x,y).  In the first case, the point t is a root of the polynomial in t, and then the point (x,y) is expressed in terms of t.  The numbers t,x,y are solvable in this case, though the explicit formula is rather complicated. In the second and third cases, we give the polynomials for x and y directly.  It is amazing to me that in these cases the polynomials have such high degree and huge coefficients.  I don't know if x and y are solvable numbers in the second and third case.";

	S=S+"\n\nWhen you click on one of these 3 squares, you will see the numerical codes of the edges which contain the vertices.  You will also see some squares colored red on the row of 6 squares.  These are the buttons for the relevant curves.   I have set things up this way so that it is easier to figure out which vertex lies on which curves.  You have to play around with the controls for a while to get a feel for how to use them effectively.";

	S=S+"\n\nYou might wonder how I found these polynomials, and what evidence I have that they are right.  In short, I asked Nathan Dunfield.  Here is a longer explanation.  I first used Mathematica to find the intersection points of the curves up to 1000 digits. Then I sent the decimal expansions to Nathan and he plugged them into sage and used their algebraic number recognizer.  I think that this is based on the LLL algorithm.  Sage spit out these huge polynomials. I then went back and computed 10000 digits of accuracy in Mathematica and saw that these polynomials vanished on the solutions up to about 10000 digits of accuracy. (Now I know how to do this whole business myself.) This convinces me that the formulas are right.";

	S=S+"\n\nI further used Sage to figure out the Galois groups of the numbers. The coordinates of the first vertex are solvable, as you can see from the formulas.  The remaining vertices have coordinates which are not solvable.  The Galois groups associated to the x-coords are the semidirect product of Z/2 with (S5)^2.   The y-coordinates are square roots of numbers which have these same Galois groups.  Incidentally, this is more evidence that the polynomials are correct. If you take a huge degree 10 polynomial with random integer coefficients, the Galois group is extremely likely to be S10.";
	
	sendTo(D,S);

    }

    public static void AF(DocumentCanvas D) {
    
	String S="AF formula display";

	S=S+"\n\nThe map construction feature shows how to construct AF geometrically, but we also give formulas.";

	S=S+"\n\nThere is a single formula for AF which is valid in each city.  The formula only depends on the zip code.  Thus, if 2 cities have the same zip code, the formula for AF is the same.  Every city can be moved by a dihedral symmetry to a city in state 5 or a city in state 6.  However city 22, which is in state 6, has the same zip code as city 0, which is in state 5.  Again applying symmetry, we see that it suffices to explain the formulas for the 4 cities in state 5.  These cities are numbered 0,1,2,3.   The formula for cities 0,3 are inverses of each other and the formulas for cities 1,2 are inverses of each other.  Thus, it suffices to describe the formulas for city 0 and city 1.  This is what we do.";

	S=S+"\n\nYou access these formulas for city 0 and city 1 by clicking on the row of two squares in the FORMULAS window. After doing this, you will see a grid of 4 tic-tac-toe boards.  Each of these 3x3 tic-tac-toe boards describes a component of the relevant map.  The map has the form (X/Z,Y/Z), and the tic-tac-toe boards describe the functions for X,Y,Z,Z.  We list Z twice just to get a nice symmetric picture.  The coefficients in the tic-tac-toe boards have the same interpretation as the coefficients in the case of the curves.";

	S=S+"\n\nHere is how to see that the formulas are correct.  Let's say you select city 0.   After doing this, drag the mouse into city 0 and note the computed value at the bottom of the FORMULA window.  When you press the AF button on the control panel, it will move the source point p to AF(p).  You can compare, and see that the new coordinates shown in the control panel will coincide with the values at the bottom of the FORMULA window. In other words, the value computed from the formula predicts where AF moves p, provided that p is in city 0.  The same goes for city 1.  After you make the selection, a little yellow cross will point out the relevant city, so you know where to move the mouse.";
	
	sendTo(D,S);
    }




}


