import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;
import java.io.File;
import javax.imageio.ImageIO;

public class FormulaCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener  {
    Manager M;
    FormulaMonomial[][] m=new FormulaMonomial[7][7];
    ListenSquare[] r=new ListenSquare[10];
    String[][] ST=new String[2][21];
    Lever[] L=new Lever[2];
    int I,J;
    ControlPanel CHOICE;
    ListenSquare[] INFO=new ListenSquare[4];
    int MODE=0;

     public FormulaCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
         L[0]=new Lever(30,20,0,6);
         L[1]=new Lever(230,20,0,3);
	 resetMonomials();
	 loadFormula0(0);
	 I=-1;J=-1;
	 INFO[0]=new ListenSquare(3,3,12,12);
	 INFO[1]=new ListenSquare(3,20,12,12);
	 INFO[2]=new ListenSquare(2033,20,12,12);
	 for(int i=0;i<21;++i) {
	     ST[0][i]="";
	     ST[1][i]="";
	 }
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      if(MODE==0) render0(g);
      if(MODE==1) render1(g);
      drawCode(g);
   }

    public void render0(Graphics2D g) {
	drawPoly(g);
        drawMono(g);
        drawValue(g);
    }
    
    public void render1(Graphics2D g) {
	drawString(g);
    }
    
    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
	g.fillRect(0,0,getWidth(),getHeight());
    }
    
    public void drawControls(Graphics2D g) {
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,0,0));
	g.fillRect(0,0,getWidth()-1,80);

	Color COL=new Color(200,0,200);
	if(MODE==0) L[0].render2(g,"curves",COL);
	if(MODE!=0) L[0].render(g,"curves",COL);
	if(MODE==1) L[1].render2(g,"vertices",COL);
	if(MODE!=1) L[1].render(g,"vertices",COL);

	for(int i=0;i<3;++i) INFO[i].infoRender(g);
    }

    public void drawCode(Graphics2D g) {
	String[] S0={"3816","8316","8369","8349","8319","8364"};
	String[] S1={"1649  (1689)  (1634)  (1638)","9468  9461  9481","9413  9481  9483"};
	String[][] S={S0,S1};
	int k=MODE;
	String SS=S[k][L[k].val];
	g.setFont(new Font("Helvetica",Font.PLAIN,25));
        g.setColor(Color.yellow);
	g.drawString(SS,130+170*MODE,34);
    }

    public static int[] intersectionCode(int n) {
	int[][] a={{5},{1,2,3},{0,3,4}};
	return a[n];
    }

    public void drawMono(Graphics2D g) {
	if(I==-1) return;
	m[I][J].renderFull(g,360,50);
    }
    
    public void drawPoly(Graphics2D g) {
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		m[i][j].render(g);
	    }
	}
    }

    public void drawValue(Graphics2D g) {
	int k=L[0].val;
	if(k>5) return;
	double x=M.P.SOURCE.x;
	double y=M.P.SOURCE.y;
	double f=Formulas.f(k,x,y);
	Double F=new Double(f);
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(Color.white);
	g.drawString("value "+F.toString(),10,70);
    }
    
    public void drawString(Graphics2D g) {
	int k=L[1].val;
	if(k>2) return;
	if(ST[0][0].length()==0) return;
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	
	for(int i=0;i<2;++i) {
	    for(int j=0;j<11;++j) {
		g.setColor(Color.blue);
		if(i==0) g.drawString(ST[i][j],40+200*i,120+30*j);
		if(i==1) g.drawString(ST[i][j],40+200*i,120+30*j);
		Integer I=new Integer(j);
		if(i==1) I=new Integer(2*j);
		
		if((k==0)&&(i==0)&&(j<4)) g.drawString("t",15,120+30*j);
		if((k==0)&&(i==0)&&(j<4)) g.drawString(I.toString(),20,112+30*j);
		
		if((k>0)&&(i==0)) g.drawString("x",15,120+30*j);
		if((k>0)&&(i==1)) g.drawString("y",15+200*i,120+30*j);

		if((k>0)&&(i==0)) g.drawString(I.toString(),22,112+30*j);
		if((k>0)&&(i==1)) {
		    g.drawString(I.toString(),22+200*i,112+30*j);
		}


	    }
	}
    }


    public void loadFormula(Point X) {
	for(int i=0;i<2;++i) {
	    int t=L[i].process(X);
	    if((t!=-1)&&(t<99)) {
		MODE=i;
		if(i==0) loadFormula0(t);
		if(i==1) loadFormula1(t);
	    }
	}
    }

    public void loadFormula0(int t) {
	resetMonomials();
	int[][] s=Formulas.signs(t);
	int[][][] a=Formulas.codes(t);
	int L=a.length;
	for(int i=0;i<L;++i) {
	    for(int j=0;j<L;++j) {
		int[] c={s[i][j],a[i][j][0],a[i][j][1]};
		m[i][j]=new FormulaMonomial(c,i,j,15+200*j,100+40*i,Color.black,15);
	    }
	}
    }


    public void loadFormula1(int t) {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<21;++j) ST[i][j]="";
	}
			  
	String[][] x=Formulas.dataT(t);
	for(int j=0;j<2;++j) {
	   for(int i=0;i<x[0].length;++i) {
	    ST[j][i]=new String(x[j][i]);
	    if((t==0)&&(j==0)) ST[j][i]="("+ST[j][i]+")";
	    if((t>0)&&(j<=2)) ST[j][i]="("+ST[j][i]+")";
	   }
	}
	int[] a=intersectionCode(t);
	for(int i=0;i<6;++i) L[0].on[i]=0;
	for(int i=0;i<a.length;++i) L[0].on[a[i]]=1;
    }
    
    
    public void resetMonomials() {
	 for(int i=0;i<4;++i) {
	     for(int j=0;j<4;++j) {
		 m[i][j]=new FormulaMonomial();
	     }
	 }
    }
    
  public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e);
       loadFormula(J.X);
       if(INFO[0].inside(J.X)==1) DocumentFormula.basic(M.D);
       if(INFO[1].inside(J.X)==1) DocumentFormula.curve(M.D);
       if(INFO[2].inside(J.X)==1) DocumentFormula.vertex(M.D);
       M.repaint();
   }

    
   public void mouseMoved(MouseEvent e) {
       MouseData J=MouseData.process(e);
       repaint();
   }

   public void mousePressed(MouseEvent e) {
   }

    
    public void mouseDragged(MouseEvent e) {
    }
    
     public void mouseReleased(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

}

