import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;
import java.io.File;
import javax.imageio.ImageIO;

public class FormulaMonomial {
    int a,b; //exponent x^a y^b
    int[] c=new int[3]; //sign,basis
    int x,y; //position
    int font;
    Color COL;

    public FormulaMonomial() {
	c[0]=1;
	c[1]=0;
	c[2]=0;
	a=0;
	b=0;
	font=20;
	COL=Color.black;
    }
    

    public FormulaMonomial(int[] c0,int a0,int b0,int x0,int y0,Color C,int font0) {
	a=a0;
	b=b0;
	font=font0;
	COL=ColorGenerator.makeTransparent(C,255);
	this.x=x0;
	this.y=y0;
	int L=c0.length;
	for(int i=0;i<3;++i) c[i]=c0[i];
    }


    public void render(Graphics2D g) {
	g.setColor(COL);
	g.setFont(new Font("Helvetica",Font.PLAIN,font));

	String E1="x^"+convert(b);
	String E2="y^"+convert(a);
	if(b==0) E1="";
	if(b==1) E1="x";
	if(a==0) E2="";
	if(a==1) E2="y";
	String E=E1+E2;
	
        String S="+";
	if(c[0]==-1) S="-";
	S=S+"\u221A("+convert(c[1])+" + "+convert(c[2])+"\u221A5)";
	S=S+" "+E;
	if((c[1]==0)&&(c[2]==0)) S="";
	
	g.drawString(S,x,y+10);
    }

    public void renderFull(Graphics2D g,int x,int y) {
    }

    public double value() {
	return 0;

    }

    public static String convert(int x) {
	Integer X=new Integer(x);
	return X.toString();
    }
    
    
}




