import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Formulas {


    public static double zeroPoint(int k,double x,double y0,double y1) {
	double a=y0;
	double b=.5*(y0+y1);
	double c=y1;
	for(int i=0;i<100;++i) {
	    double test=f(k,x,b);
	    if(test>=0) a=b;
	    if(test<=0) c=b;
	    b=.5*(a+c);
	}
	return b;
    }

    public static Complex[] curve(int k,int N) {
	Complex[] Z=new Complex[N+1];
	int count=0;
	int[] a=endpoints(k);
        Complex z0=vtx(a[0]);
	Complex z1=vtx(a[1]);
	double[] X={z0.x,z1.x};

	for(int i=0;i<=N;++i) {
	    double t=1.0*i/N;
	    double x=(1-t)*X[0]+t*X[1];
	    double y=zeroPoint(k,x,-1,1);
	    Z[count]=new Complex(x,y);
	    ++count;
	}
	return Z;
    }
    
    public static Complex[] curveExtended(int k,int N) {
	Complex[] Z=new Complex[N+1];
	int count=0;
	double[] X={0,1};

	for(int i=0;i<=N;++i) {
	    double t=1.0*i/N;
	    double x=(1-t)*X[0]+t*X[1];
	    double y=zeroPoint(k,x,-1,1);
	    Z[count]=new Complex(x,y);
	    ++count;
	}
	return Z;
    }

    public static int[] endpoints(int k) {
	int[][] t={{0,1},{1,2},{2,3},{3,4},{5,2},{3,6}};
	return t[k];
    }

    public static Complex vtx(int k) {
	if(k==0) return vtx0();
	if(k==1) return vtx1();
	if(k==2) return vtx2();
	if(k==3) return vtx3();
	if(k==4) return vtx4();
	if(k==5) return vtx5();
	if(k==6) return vtx6();
	return null;
    }

    public static Complex vtx0() {
	double x=0.20238832960837992;
	double y=-0.1470437286324545;
      return new Complex(x,y);
    }

    public static Complex vtx1() {
        double x=0.30901699437494742;
	double y=0;
      return new Complex(x,y);
    }
    
    
    public static Complex vtx2() {
       double x=0.4573149127477759731;
       double y=0.2048778281244115161;
      return new Complex(x,y);
    }

    public static Complex vtx3() {
       double x=0.4630493473280106522218;
       double y=0.214589800855506797725;
      return new Complex(x,y);
    }
    
    public static Complex vtx4() {
      double x=0.6545084971874737;
      double y=0.475528258147576786;
      return new Complex(x,y);
    }

    public static Complex vtx5() {
        double x=0.30901699437494742;
	double y=0.224513988289792686;
      return new Complex(x,y);
    }
    
    public static Complex vtx6() {
	return new Complex(1,0);
    }

    public static double f(int k,double x,double y) {
	int[][] s=signs(k);
	int[][][] c=codes(k);
	double sum=0;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		int ss=s[i][j];
		double mono=Math.pow(x,j)*Math.pow(y,i);
		double coeff=0;
		if(c[i][j].length<2) coeff=c[i][j][0];
		else coeff=Math.sqrt(c[i][j][0]+c[i][j][1]*Math.sqrt(5));
		sum=sum+mono*ss*coeff;
	    }
	}
	return -sum;
    }
    

    
    public static double p(double x,double y) {
        return Math.pow(x,y);
    }

    public static double sq(double r) {
	return Math.sqrt(r);
    }


    public static double decode(int[][][] k,double x,double y) {
	return 0;
    }


    public static int[][] signs(int k) {
	int[][][] x=
{{{1, -1, -1, 1}, {1, 1, -1, 0}, {-1, 1, 0, 0}, {-1, 0, 0, 0}},
 {{1, -1, -1, 1}, {1, 1, -1, 0}, {-1, 1, 0, 0}, {-1, 0, 0, 0}},
 {{1, -1, -1, 1}, {1, 1, -1, 0}, {-1, 1, 0, 0}, {-1, 0, 0, 0}},
 {{1, -1, -1, 1}, {1, -1, 1, 0}, {-1, 1, 0, 0}, {1, 0, 0, 0}},
 {{0, -1, 1, -1}, {1, 1, -1, 0}, {-1, -1, 0, 0}, {-1, 0, 0, 0}},
 {{0, -1, 1, 1}, {1, 1, 1, 0}, {-1, 1, 0, 0}, {1, 0, 0, 0}}};
	return x[k];
    }

  public static int[][][] codes(int k) {
int[][][][] x=

{
    {{{50, 20}, {585, 171}, {225, -99}, {40, -16}}, {{283, 105}, {12, -4}, {8,0}, {0,0}}, {{25, -11}, {40, -16}, {0,0}, {0,0}}, {{8,0},{0,0}, {0,0}, {0,0}}},
    {{{50, 20}, {585, 171}, {225, -99}, {40, -16}}, {{283, 105}, {12, -4}, {8,0}, {0,0}}, {{25, -11}, {40, -16}, {0,0}, {0,0}}, {{8,0},{0,0}, {0,0}, {0,0}}},
    {{{4700, 2100}, {41160, 18400}, {210, 80}, {175, 75}}, {{14180, 6316}, {1220, 524}, {5, 1}, {0,0}}, {{2010, 880}, {175, 75}, {0,0}, {0,0}}, {{5, 1}, {0,0}, {0,0}, {0,0}}},
    {{{940, 420}, {9840, 4400}, {235, 105}, {60, 20}}, {{7780, 3476}, {100, 44}, {20, -4}, {0,0}}, {{75, 25}, {60, 20}, {0,0}, {0,0}}, {{20, -4}, {0,0}, {0,0}, {0,0}}},
    {{{0,0}, {85, 38},{130, 58},{5, 2}},{{29, 12},{206, 90}, {9, 4}, {0,0}}, {{20, 8},{5, 2}, {0,0}, {0,0}}, {{9, 4}, {0,0}, {0,0}, {0,0}}},
    {{{0,0}, {126075, 42025}, {58835, 25215}, {16810,0}}, {{109265, 31939}, {336200, 26896}, {16810, 6724}, {0,0}}, {{294175, 126075}, {16810,0}, {0,0}, {0,0}}, {{16810, 6724}, {0,0}, {0,0}, {0,0}}}};
return x[k];
  }




    /**This is the data for the interior vertices*/
    
    public static String[][] dataT(int k) {
	if(k==0) return dataT1();
	if(k==1) return dataT2();
	if(k==2) return dataT3();
	return null;
    }
    

    public static String[][] dataT1() {
	String[][] x={{"5+3\u221A5","-24-10\u221A5","-5+\u221A5","4"},{"x=t cos(\u03C0/5)","y=-t sin(\u03C0/5)","","",""}};
	return x;
    }


    public static String[][] dataT2() {
	String[][] x={{"-316255","-2058230","-2274924","5867624","21442368","16940800","-2981184","-14747520","-8346368","83968","618496"},
		      {"30628125","-3987022500","182759180400","-3779346139200","33477163496960","-76699297095680","55055853490176","-7975706116096","1037341884416","-1942052929536","382537302016"}};
	return x;
    }

    
    public static String[][] dataT3() {
	String[][] x={{"261041","218379","480105","-456166","-6191440","-4588496","-70160","-6282016","-3905600","48384","185344"},
		      {"114003125","-3685145625","49461396125","-569280022300","1528734099680","-2363147567360","1442069796096","1127893175296","-572734828544","-155779661824","34352398336"}};
	return x;
    }




    

    /**these are not used but let's keep them around for debugging.*/

public static double ff(int k,double x,double y) {
    if(k==0) return f8316(x,y);
    if(k==1) return f8316(x,y);
    if(k==2) return f8369(x,y);
    if(k==3) return f8349(x,y);
    if(k==4) return f8319(x,y);
    if(k==5) return f8346(x,y);
    return 0;
}

    public static double f8316(double x,double y) {
      double f=2*sq(5*(5 + 2*sq(5))) + 4*sq(5 - 2*sq(5))*p(x,3) - p(x,2)*(3*sq(50 - 22*sq(5)) + 4*y) + 
      y*(21 + 5*sq(5) - y*(sq(50 - 22*sq(5)) + 4*y)) + 
      x*(-3*sq(130 + 38*sq(5)) + 2*y*(-1 + sq(5) + 2*sq(5 - 2*sq(5))*y));
    return -f;
    }
    
  public static double f8369(double x,double y) {
double f=150 + 70*sq(5) - 460*x - 200*sq(5)*x - 40*p(x,2) - 10*sq(5)*p(x,2) + 25*p(x,3) + 
   15*sq(5)*p(x,3) + 2*sq(35450 + 15790*sq(5))*y + 2*sq(3050 + 1310*sq(5))*x*y -
    sq(10*(5 + sq(5)))*p(x,2)*y - 110*p(y,2) - 40*sq(5)*p(y,2) +
    25*x*p(y,2) + 15*sq(5)*x*p(y,2) - sq(10*(5 + sq(5)))*p(y,3);
return -f;
  }
   
  public static double f8349(double x,double y) {
double f=40*(7 + 3*sq(5)) + 40*(1 + sq(5))*p(x,3) + 8*sq(19450 + 8690*sq(5))*y - 
   20*(5 + sq(5))*p(y,2) + 8*sq(50 - 10*sq(5))*p(y,3) + 
   4*p(x,2)*(-5*(7 + 3*sq(5)) + 2*sq(50 - 10*sq(5))*y) - 8*x*(110 +
   50*sq(5) + y*(sq(250 + 110*sq(5)) - 5*(1 + sq(5))*y));
return -f;
  } 
    public static double f8319(double x,double y) {
double f=-6*sq(2*(85 + 38*sq(5)))*x + 12*sq(65 + 29*sq(5))*p(x,2) - 6*sq(10 + 4*sq(5))*p(x,3) + 
   18*sq(2)*y + 12*sq(10)*y + 54*sq(2)*x*y + 30*sq(10)*x*y - 12*sq(2)*p(x,2)*y - 
   6*sq(10)*p(x,2)*y - 12*sq(2*(5 + 2*sq(5)))*p(y,2) - 6*sq(2*(5 + 2*sq(5)))*x*p(y,2) - 
    12*sq(2)*p(y,3) - 6*sq(10)*p(y,3);
   return -f;
    }
    
  public static double f8346(double x,double y) {
double f=-1025*sq(2)*x - 205*sq(10)*x + 615*sq(2)*p(x,2) + 205*sq(10)*p(x,2) + 410*sq(2)*p(x,3) + 
   82*sq(325 + 95*sq(5))*y + 164*sq(10*(25 + 2*sq(5)))*x*y + 82*sq(10*(5 + 2*sq(5)))*p(x,2)*y - 
   1025*sq(2)*p(y,2) - 615*sq(10)*p(y,2) + 410*sq(2)*x*p(y,2) + 
    82*sq(10*(5 + 2*sq(5)))*p(y,3);
return -f;
  }

    
    
}




    
