import java.awt.*;

public class ListHelp {


    public static int[][] irredundantDihedral(int[][] LIST) {
	int L=LIST.length;
	int count=0;
	int[][] LIST2=new int[L][0];
	
	for(int i=0;i<L;++i) {
	    boolean test=onListDihedral(LIST[i],LIST2,count);
	    if(test==false) {
		LIST2[count]=LIST[i];
		++count;
	    }
	}
	return trim(LIST2,count);
    }


    

    public static boolean onListDihedral(int[] I,int[][] LIST,int COUNT) {
	for(int i=0;i<COUNT;++i) {
	    if(dihedralMatch(I,LIST[i])==true) return true;
	}
	return false;
    }

    public static boolean onList(int q,int[] a,int n) {
	for(int i=0;i<n;++i) {
	    if(q==a[i]) return true;
	}
	return false;
    }


    public static boolean dihedralMatch(int[] I,int[] J) {
	if(I.length!=J.length) return false;
	if(cyclicMatch(I,J)==true) return true;
	if(cyclicMatch(I,reverse(J,J.length))==true) return true;
	return false;
    }

    public static boolean cyclicMatch(int[] I,int[] J) {
	if(I.length!=J.length) return false;
	for(int i=0;i<I.length;++i) {
            if(match(I,rotate(J,i))==true) return true;
	}
	return false;
    }

    public static boolean match(int[] I,int [] J) {
	if(I.length!=J.length) return false;
	for(int i=0;i<I.length;++i) {
	    if(I[i]!=J[i]) return false;
	}
	return true;
    }

    public static boolean cyclicallyLeast(int[] I) {
	for(int i=1;i<I.length;++i) {
	    
	    if(I[i]==0) {
	      int[] J=rotate(I,i);
	      if(lessThan(J,I,I.length-i)==true) return false;
	    }
	    
	}
	return true;
    }

    public static boolean dihedrallyLeast(int[] I) {
	for(int i=1;i<I.length;++i) {
	    if(I[i]==0) {
	      int[] J=rotate(I,i);
	      if(lessThan(J,I,I.length-i)==true) return false;
	      int[] K=reflect(I,i);
	      if(lessThan(K,I,i)==true) return false;
	    }
	}
	return true;
    }

    

    public static boolean lessThan(int[] I,int [] J,int count) {
	if(I.length!=J.length) return false;
	for(int i=0;i<count;++i) {
	    if(I[i]>J[i]) return false;
	    if(I[i]<J[i]) return true;
	}
	return false;
    }


    

    public static void print(int[] move) {
	for(int i=0;i<move.length;++i) System.out.print(move[i]);
	System.out.println("");
    }


    public static int[] reverse(int[] list1,int count) {
	int[] list2=new int[count];
	for(int i=0;i<count;++i) list2[i]=list1[count-1-i];
	return(list2);
    }

    public static int[] rotate(int[] list1,int k) {
	int n=list1.length;
	int[] list2=new int[n];
	for(int i=0;i<n;++i) list2[i]=list1[(i+k)%n];
	return(list2);
    }

    public static int[] reflect(int[] list1,int k) {
	int n=list1.length;
	int[] list2=new int[n];
	for(int i=0;i<n;++i) {
	    int j=(k+n-i)%n;
	    list2[i]=list1[j];
	}
	return list2;
    }

    public static int[] augment(int[] a) {
	int[] b=new int[a.length+1];
	for(int i=0;i<a.length;++i) b[i]=a[i];
	b[a.length]=a[0];
	return b;
    }

    public static int[] trim(int[] list,int count) {
	int[] list2=new int[count];
	for(int i=0;i<count;++i) list2[i]=list[i];
	return list2;
    }
    
    public static int[][] trim(int[][] list,int count) {
	int[][] list2=new int[count][0];
	for(int i=0;i<count;++i) list2[i]=list[i];
	return list2;
    }

    public static int[] toSequence(String S) {
	int[] s=new int[S.length()];
	for(int i=0;i<S.length();++i) {
	    Integer I=new Integer(S.substring(i,i+1));
	    s[i]=I.intValue();
	}
	return s;
    }
    
    public static String toString(int[] k) {
	String S="";
	Integer I=new Integer(0);
	for(int i=0;i<k.length;++i) {
	    I=new Integer(k[i]);
	    S=S+I.toString();
	}
	return S;
    }
    
    public static String toStringDeplete(int[] k) {
	String S="";
	Integer I=new Integer(0);
	for(int i=0;i<k.length-1;++i) {
	    I=new Integer(k[i]);
	    S=S+I.toString();
	}
	return S;
    }

    public static Color copy(Color C) {
	int r=C.getRed();
	int g=C.getGreen();
	int b=C.getBlue();
	int a=C.getAlpha();
	return new Color(r,g,b,a);
    }

}
