import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class MapConstruction {


    public static Complex v5(double j) {
	return Decagon.rootOfUnity5(j);
    }

    /**This routine gets three of the 3 rhombus points.
       Here k=0,...,59 is the city number*/


    public static Complex[] map(int k) {
	Complex[] q=map1(k%12);
	int r=(k-k%12)/12;
	for(int i=0;i<3;++i) q[i]=Complex.times(q[i],v5(r));
	return q;
    }
	

    public static Complex[] map1(int k) {
	if(k>11) return null;
	Complex[] q=map0(k%6);
	if(k<6) return q;
	for(int i=0;i<3;++i) q[i]=Complex.times(q[i].conjugate(),v5(1));
	return q;
    }

    public static Complex[] map0(int k) {
	if(k==0) return map941();
	if(k==1) return map943();
	if(k==2) return map948();
	if(k==3) return map946();
	if(k==4) return map941B();
	if(k==5) return map943B();
	return null;
    }

	
    /**We compute the rhombus control points for a representative
       set of examples and then (above) we apply symmetry to get
       these control points for all the cities*/
    
    public static Complex[] map941() {
	Complex ZERO=new Complex(0,0);
	Complex q0=Complex.plus(v5(0),Complex.minus(v5(0),v5(2)));
	Complex q1=Vector.findCross2(ZERO,v5(1),v5(0),v5(2));
	Complex q2=Vector.findCross2(ZERO,v5(1),q0,Complex.plus(q0,v5(4)));
	Complex[] qq={q0,q1,q2};
	return qq;
    }


    public static Complex[] map943() {
	Complex ZERO=new Complex(0,0);
	Complex q0=v5(3);
	double phi=(1+Math.sqrt(5))/2;
	q0=q0.scale(phi);
	Complex q1=Vector.findCross2(q0,ZERO,v5(0),v5(1));
	Complex q2=Vector.findCross2(q0,Complex.plus(q0,v5(4)),v5(0),v5(1));
	Complex[] qq={q0,q1,q2};
	return qq;
    }

    public static Complex[] map946() {
	Complex ZERO=new Complex(0,0);
	Complex q0=Complex.plus(v5(0),Complex.minus(v5(0),v5(2)));
	Complex q1=Vector.findCross2(ZERO,v5(1),v5(0),v5(2));
	Complex q2=Vector.findCross2(ZERO,v5(1),q0,Complex.plus(q0,v5(4)));
	Complex q3=Complex.plus(q1,Complex.minus(q1,q0));
	Complex q4=Complex.minus(Complex.plus(q0,q3),q2);
	Complex[] qq={q3,q1,q4};
	return qq;
    }

    public static Complex[] map948() {
	Complex ZERO=new Complex(0,0);
	double phi=(1+Math.sqrt(5))/2;
	Complex q0=v5(3);
	q0=q0.scale(phi);
	Complex q1=Vector.findCross2(q0,ZERO,v5(0),v5(1));
	Complex q2=Vector.findCross2(q0,Complex.plus(q0,v5(4)),v5(0),v5(1));
	Complex q3=Complex.plus(q1,Complex.minus(q1,q0));
	Complex q4=Complex.minus(Complex.plus(q0,q3),q2);
	Complex[] qq={q3,q1,q4};
	return qq;
    }
    
    public static Complex[] map941B() {
	Complex[] qq=map941();
	for(int i=0;i<3;++i) qq[i]=Complex.times(qq[i].conjugate(),v5(2));
	return qq;
    }
    
    public static Complex[] map943B() {
	Complex[] qq=map946();
	for(int i=0;i<3;++i) qq[i]=Complex.times(qq[i].conjugate(),v5(2));
	return qq;
    }

    /**end construction of the rhombus control points*/



    /**This routine draws the map.   Here...
       T is the set of rhombus control points.
       z1 is the SOURCE point*/


    public static void drawMap(PictureCanvas PIC,Graphics2D g,Complex[] T,PolygonWrapper POLY,Complex z1) {
	Complex t0=T[0];
	Complex t1=T[1];
	Complex t2=T[2];
	
	Color C=new Color(50,50,50);
	Complex z2=Complex.plus(z1,Complex.minus(t0,t2));
	Complex t3=Complex.plus(t1,Complex.minus(t1,t0));
	Complex t4=Complex.minus(Complex.plus(t0,t3),t2);
	Complex[] tt={t0,t2,t3,t4};
	
	g.setStroke(new BasicStroke(2));
       	drawSegment(PIC,g,t0,z1,C);
	Complex z3=Vector.findCross2(t2,t4,t0,z1);
       	drawSegment(PIC,g,t0,z3,C);
	Complex z4=Vector.findCross2(t3,z3,z1,z2);
        drawSegment(PIC,g,t3,z3,C);
       	drawSegment(PIC,g,t3,z4,C);
	g.setStroke(new BasicStroke(1));

	boolean test=false;
	double position=0;
	while(test==false) {
	    double s=position;
	    Complex w40=Complex.plus(t4.scale(1-s),t0.scale(s));
	    Complex w32=Complex.plus(t3.scale(1-s),t2.scale(s));
	    Complex[] w={w40,w32};
	    w=POLY.intersect(w);
	    if(w==null) position=position+.01;
	    if(w!=null) position=position+.001;
	    if(w!=null) drawSegment(PIC,g,w[0],w[1],new Color(0,0,0,50));
	    if(position>=1) test=true;
	}
	

	drawSegment(PIC,g,t2,t4,new Color(100,100,100));
	drawSegment(PIC,g,t0,t3,new Color(100,100,100));
	PolygonWrapper P=new PolygonWrapper(4,tt);
	Path2D.Double p=P.toPath();
	p=PIC.transform(p);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }
    
    public static void drawSegment(PictureCanvas PIC, Graphics2D g,Complex a,Complex b,Color C) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(a.x,a.y);
	p.lineTo(b.x,b.y);
	p=PIC.transform(p);
	g.setColor(C);
	g.draw(p);
    }
    


}


