
(*This file generates the 360 polynomials that we analyze*)
(* in Chapter 5.  We also store these files in the 6 files:*)
(* dodeca_stored163.m *)
(* dodeca_stored168.m *)
(* dodeca_stored831.m *)
(* dodeca_stored836.m *)
(* dodeca_stored834.m *)
(* dodeca839_stored.m *)
(* In running the proof, you do not have to regenerate the *)
(* functions.  But, it is nice to have a record of how we got them *)
(* If you want to use the stored versions, here is their structure:*)
(* The file dodeca_stored163 has a function F163, which is a list of 60 polys*)
(* The polynomial F163[[j]] corresponds to the function City162[1,x,y]*)
(* The other files work the same way.*)

(*We have to load in this function first*)
<<dodeca_code.m
<<dodeca_triangle.m

(**Getting the 60 competing points*)
BAD={{2,4,3,0,1,4},{1,4,3,2,0,6},{1,3,4,2,0,6},{0,2,4,3,1,8},{2,2,5,3,0,7},{0,2,3,5,2,9},
     {3,4,2,1,0,4},{3,4,1,0,2,2},{4,3,1,0,2,2},{4,2,0,1,3,0},{5,2,2,0,3,1},{3,2,0,2,5,9}};
COMPETITOR0[i_,j_,x_,y_]:=CodeTransplant[ROTATE[BAD[[j]],i],x,y];
COMPETITOR[x_,y_]:=Flatten[Table[Table[COMPETITOR0[i,j,x,y],{i,0,4}],{j,1,12}]];
(*End competing points*)



(*Here are the main functions*)
City163[i_,x_,y_]:=Cocirc1[1,6,3,i,P1g0[{x,y}]];
City168[i_,x_,y_]:=Cocirc1[1,6,8,i,P1g0[{x,y}]];
City834[i_,x_,y_]:=Cocirc1[8,3,4,i,P1g1[{x,y}]];
City839[i_,x_,y_]:=Cocirc1[8,3,9,i,P1g1[{x,y}]];
City831[i_,x_,y_]:=Cocirc1[8,3,1,i,P1g2[{x,y}]];
City836[i_,x_,y_]:=Cocirc1[8,3,6,i,P1g2[{x,y}]];

Cocirc1[i_,j_,k_,s_,{x_,y_}]:=(
poly0=Cocirc10[i,j,k,s,{x,y}];
poly1=ComplexExpand[poly0];
poly2=Simplify[poly1,Algebraics];
poly3=Expand[Numerator[poly2]];
sign=CoeffSum[poly3];
Expand[sign poly3])


Cocirc10[i_,j_,k_,s_,{x_,y_}]:=Refine[(
z1=VERTEX[i,x,y];
z2=VERTEX[j,x,y];
z3=VERTEX[k,x,y];
z4=COMPETITOR[x,y][[s]];
Im[(z1-z3) (z2-z4)/(z1-z2)/(z3-z4)]),
{Element[x,Reals],Element[y,Reals]}]
(*End main functions*)


CoeffSum[poly_]:=(
arr1=Table[Table[Coefficient[Coefficient[poly,x,i],y,j],{i,0,4}],{j,0,4}];
arr2=Flatten[arr1];
arr3=Sum[arr2[[j]],{j,1,Length[arr2]}];
Sign[FullSimplify[arr3]])
