
(**These are the routines for chapter 6 of the paper*)
(**There are 3 kinds of tests:*)
(**The comparison tests.  These are the edges e16 and e38 in the paper*)
(**The stability tests.  These are for the other key edges in the Voronoi decomposition*)
(**The confinement tests.  These are for showing that the vertices of the Voronoi decomp lie in Delta*)
(** test produces a list of functions which we use the positive dominance criterion*)
(** to prove are nonvanishing on [0,1]^2*)
(**The first list of functions is COMPAREList[]*)
(**The second list of functions is STABLEList[]*)
(**The third list of functions is CONFINEList[]*)

(*We first load the file has the formulas for the vertices of the decagon*)
(*And also the formulas for the triple points*)
(*We also load the file which has the formulas for the triangle maps*)
<<dodeca_code.m
<<dodeca_triangle.m



(*Comparison tests.  For the central edge stability:*)
 (*COMPARE0 has arguments j=3,4,8,9*)
 (*COMPARE1 has arguments j=1,4,6,9*)
 (*COMPARE2 has arguments j=1,4,6,9*)

(********************************)
(********************************)
(*Here is the main routine.  These 16 functions should be positive on [0,1[^2*)
COMPAREList[]:=Flatten[{COMPAREList0[x,y],COMPAREList1[x,y],COMPAREList2[x,y],COMPAREList3[x,y]}];
(********************************)
(********************************)

COMPAREList0[x_,y_]:=(
aa={3,4,8,9};
Table[COMPARE0[aa[[j]],x,y],{j,1,4}])

COMPAREList1[x_,y_]:=(
aa={1,4,6,9};
Table[COMPARE1[aa[[j]],x,y],{j,1,4}])

COMPAREList2[x_,y_]:=(
aa={1,4,6,9};
Table[COMPARE2[aa[[j]],x,y],{j,1,4}])
  
COMPAREList3[x_,y_]:=(
aa={1,4,6,9};
Table[COMPARE3[aa[[j]],x,y],{j,1,4}])

COMPARE0[j_,x_,y_]:=COMPARE[1,j,P2g0[{x,y}]];
COMPARE1[j_,x_,y_]:=COMPARE[3,j,P2g1[{x,y}]];
COMPARE2[j_,x_,y_]:=COMPARE[3,j,P2g2[{x,y}]];
COMPARE3[j_,x_,y_]:=COMPARE[3,j,P2g3[{x,y}]];

COMPARE[i_,j_,{x_,y_}]:=Refine[(
 vv1=VERTEX[i,x,y]-(x + I y);
 vv2=VERTEX[j,x,y]-(x + I y);
 dd=vv2 Conjugate[vv2] - vv1 Conjugate[vv1];
ComplexExpand[dd]),{Element[x,Reals],Element[y,Reals]}];
(*End comparison tests*)



(*Stability/cocircularity tests*)

EDGELIST0={{1,6,8,9},{1,3,4,6}};
EDGELIST1={{1,3,8,9},{3,4,6,8}};
EDGELIST3={{1,3,8,9},{3,4,6,8}};

(********************)
(********************)
(*Here is the main list.  The 6 functions should be nonvanishing on [0,1]^2*)
STABLEList[]:=Flatten[{STABLEList0[],STABLEList1[],STABLEList3[]}];
(********************)
(********************)

STABLEList0[]:=Table[STABLE0[i,x,y],{i,1,2}];
STABLEList1[]:=Table[STABLE1[i,x,y],{i,1,2}];
(*The case for triangle 2 is deliberately missing*)
STABLEList3[]:=Table[STABLE3[i,x,y],{i,1,2}];

STABLE0[i_,x_,y_]:=(
II=EDGELIST0[[i]];
Cocirc2[II,P2g0[{x,y}]])

STABLE1[i_,x_,y_]:=(
II=EDGELIST1[[i]];
Cocirc2[II,P2g1[{x,y}]])

STABLE3[i_,x_,y_]:=(
II=EDGELIST1[[i]];
Cocirc2[II,P2g3[{x,y}]])


Cocirc2[{i_,j_,k_,s_},{x_,y_}]:=(
poly0=Cocirc0[i,j,k,s,{x,y}];
eval0=Sign[Cocirc20[i,j,k,s,{1/2,1/2}]//N];
poly1=ComplexExpand[poly0];
poly2=Simplify[poly1,Algebraics];
Expand[Numerator[poly2/eval0]])

Cocirc20[i_,j_,k_,s_,{x_,y_}]:=Refine[(
z1=VERTEX[i,x,y];
z2=VERTEX[j,x,y];
z3=VERTEX[k,x,y];
z4=VERTEX[s,x,y];
Im[(z1-z3) (z2-z4)/(z1-z2)/(z3-z4)]),
{Element[x,Reals],Element[y,Reals]}]



(*Confinement tests.  These are the tests which show*)
(*That the relevant triple points lie in the triangle Delta*)

  (*triangle Delta vertices*)
  DELTA[0]:={0,0};
  DELTA[1]:={1,0};
  DELTA[2]:={Cos[2 Pi/5],Sin[2 Pi/5]};
  DELTA[3]:={0,0};

TRIPLELIST0={{1,6,8},{1,8,9},{3,4,6},{1,3,6}};
TRIPLELIST1={{8,3,1},{8,3,6},{1,8,9},{3,4,6}};
TRIPLELIST2={{3,8,9},{3,9,1},{8,9,1},{3,8,1},{3,4,6},{3,6,8},{4,6,8},{3,4,8}};
TRIPLELIST3={{1,3,9},{4,6,8},{8,3,4},{8,3,9}};

(**************************)
(**************************)
(*Here is the main list.  These 60 functions should be nonvanishing on [0,1]^2*)
CONFINEList[]:=Flatten[{CONFINEList0[],CONFINEList1[],CONFINEList2[],CONFINEList3[]}];
(**************************)
(**************************)

CONFINEList0[]:=Table[Table[CONFINE0[j,k,x,y],{j,1,3}],{k,1,4}];
CONFINEList1[]:=Table[Table[CONFINE1[j,k,x,y],{j,1,3}],{k,1,4}];
CONFINEList2[]:=Table[Table[CONFINE2[j,k,x,y],{j,1,3}],{k,1,8}];
CONFINEList3[]:=Table[Table[CONFINE3[j,k,x,y],{j,1,3}],{k,1,4}];

(**Confine tests*)
CONFINE0[j_,k_,x_,y_]:=(
jj1=Mod[j,3];
jj2=Mod[jj1+1,3];
aa=TRIPLELIST0[[k]];
vec1=TRIPLE[aa[[1]],aa[[2]],aa[[3]],P2g0[{x,y}]];
vec2=DELTA[jj1];
vec3=DELTA[jj2];
ff1=TRIPLEPRODUCT[vec1,vec2,vec3];
ff2=Simplify[ff1,Algebraics];
Numerator[ff2])


CONFINE1[j_,k_,x_,y_]:=(
jj1=Mod[j,3];
jj2=Mod[jj1+1,3];
aa=TRIPLELIST1[[k]];
vec1=TRIPLE[aa[[1]],aa[[2]],aa[[3]],P2g1[{x,y}]];
vec2=DELTA[jj1];
vec3=DELTA[jj2];
ff1=TRIPLEPRODUCT[vec1,vec2,vec3];
ff2=Simplify[ff1,Algebraics];
Numerator[ff2])


CONFINE2[j_,k_,x_,y_]:=(
jj1=Mod[j,3];
jj2=Mod[jj1+1,3];
aa=TRIPLELIST2[[k]];
vec1=TRIPLE[aa[[1]],aa[[2]],aa[[3]],P2g2[{x,y}]];
vec2=DELTA[jj1];
vec3=DELTA[jj2];
ff1=TRIPLEPRODUCT[vec1,vec2,vec3];
ff2=Simplify[ff1,Algebraics];
Numerator[ff2])

CONFINE3[j_,k_,x_,y_]:=(
jj1=Mod[j,3];
jj2=Mod[jj1+1,3];
aa=TRIPLELIST3[[k]];
vec1=TRIPLE[aa[[1]],aa[[2]],aa[[3]],P2g3[{x,y}]];
vec2=DELTA[jj1];
vec3=DELTA[jj2];
ff1=TRIPLEPRODUCT[vec1,vec2,vec3];
ff2=Simplify[ff1,Algebraics];
Numerator[ff2])

TRIPLEPRODUCT[v1_,v2_,v3_]:=(
vv1=Append[v1,1];
vv2=Append[v2,1];
vv3=Append[v3,1];
vv1.Cross[vv2,vv3])

  (*End confinement tests*)
