(*This file generates some of the functions which we analyze*)
(*in Chapter 7 of the paper. The file dodeca_functions.m*)
(*also has these files pre-stored. *)
(*We use this file for the indices 1638,8349,8369*)
(*In each case we get the function f(ijkl).  In the stored function file*)
(*We mentioned above, we list all the factors of f, namely g and h.*)
(*You can verify in each case that f=gh. *)
(*For the quadruples 8319 and 8346 we use the Cocirc function*)
(*Contained in the file dodeca2.m*)

(*We have to load in the file that defines the vertices and triple points*)
<<dodeca_code.m

    GENERATE[i_,j_,k_,l_,x_,y_]:=(
    p1=TRIPLE[i,j,k,{x,y}];
    p2=TRIPLE[i,j,l,{x,y}];
    pp3=VERTEX[i,x,y];
    p3=ComplexExpand[{Re[pp3],Im[pp3]}];
    ff1=(p3-p2).(p3-p2) - (p3-p1).(p3-p1);
    Numerator[Together[ff1]])
    

  (*Here is the cocirc region repeated for convenience*)

 <<dodeca_code.m

Cocirc3[{i_,j_,k_,s_},{x_,y_}]:=(
poly0=Cocirc30[i,j,k,s,{x,y}];
eval0=Sign[Cocirc30[i,j,k,s,{1/2,1/2}]//N];
poly1=ComplexExpand[poly0];
poly2=Simplify[poly1,Algebraics];
Expand[Numerator[poly2/eval0]])

Cocirc30[i_,j_,k_,s_,{x_,y_}]:=Refine[(
z1=VERTEX[i,x,y];
z2=VERTEX[j,x,y];
z3=VERTEX[k,x,y];
z4=VERTEX[s,x,y];
Im[(z1-z3) (z2-z4)/(z1-z2)/(z3-z4)]),
{Element[x,Reals],Element[y,Reals]}]

