(*This file contains the formulas for the vertices of the decagon*)
(*The file also contains the routine which computes the triple points*)



  (**This defines the transplant operations for chains.  The input is a
   chain code and a point p in the central face of the dodecahedron.
   The output is the developing image of A(p) under the chain*)

CodeTransplant[J_,x_,y_]:=Refine[(
 z=x+I y;
 rot=Exp[J[[6]] I Pi/5];
 Conjugate[z]*rot+IntegerCombo[J]),
 {Element[x,Reals],Element[y,Reals]}]
		  

IntegerCombo[J_]:=Sum[J[[k]] RootOfUnity5[k-1],{k,1,5}];

RootOfUnity5[k_]:=Exp[2 Pi I k/5];

(*end of transplant routine*)




(*Here are the decagon vertices: VERTEX[j] for j=0,...,9]*)

GOOD={{1,3,3,0,0,5},{3,3,1,0,0,3}};
ROTATE[J_,k_]:=Flatten[{RotateRight[Take[J,5],k],J[[6]]+4 k}];
MOD[j_,k_]:=If[Mod[j,k]==0,k,Mod[j,k]];
STEP={1,1,0,0,4,4,3,3,2,2};
VERTEX[j_,x_,y_]:=CodeTransplant[ROTATE[GOOD[[MOD[j+1,2]]],STEP[[j+1]]],x,y];

(*End of vertices*)


(* the triple points*)

  TRIPLE[i_,j_,k_,{x_,y_}]:=(
  V1=VERTEX[i,x,y];
  V2=VERTEX[j,x,y];
  V3=VERTEX[k,x,y];
  AA12=(V1+V2)/2;
  BB12=(V1-V2) I;
  CC12=AA12+BB12;
  AA23=(V3+V2)/2;
  BB23=(V3-V2) I;
  CC23=AA23+BB23;

  FF12=ComplexExpand[{Re[AA12],Im[AA12]}];
  GG12=ComplexExpand[{Re[CC12],Im[CC12]}];
  FF23=ComplexExpand[{Re[AA23],Im[AA23]}];
  GG23=ComplexExpand[{Re[CC23],Im[CC23]}];

  FF12=Append[FF12,1];
  GG12=Append[GG12,1];
  FF23=Append[FF23,1];
  GG23=Append[GG23,1];

  II=Cross[Cross[FF12,GG12],Cross[FF23,GG23]];
  JJ=II/II[[3]];
  Take[JJ,2])
  
  (* end triple points*)
