

(*Here is the main test*)

PosdomTest[poly_]:=(
pos=POSDOM[ARRAY[poly]];
min=Min[pos];
max=Max[pos];
min*max)

  (*This test is meant to be used with a polynomial in 2 variables*)
  (*In which the maximum exponent of any variable is 5.  This covers*)
  (*All the polynomials we test by a wide margin.  The variables of the polynomial*)
  (*Are a,b.  The polynomials we list have variables x and y.*)
  (*So, we need to make a substitution first.  In Mathematica we would run:*)
  (* x=a;y=b;PosdomTest[f]*)
  (* for the function f*)
  (*The reason we do things this way is for added flexibility.  We often do these 2 tests instead*)
  (*x=a/2;y=b;PosdomTest[f]*)
  (*x=1-a/2;y=b;PosdomTest[f]*)
  (*Sometimes we do these 4 tests instead*)
  (*x=a/2;y=b/2;PosdomTest[f]*)
  (*x=1-a/2;y=b/2;PosdomTest[f]*)
  (*x=a/2;y=1-b/2;PosdomTest[f]*)
  (*x=1-a/2;y=1-b/2;PosdomTest[f]*)

  (*This gets the coefficients of the polynomial and arranges it into a matrix*)

ARRAY[POLY_]:=Table[Table[TERM[POLY,i,j],{i,0,5}],{j,0,5}]
TERM[POLY_,i_,j_]:=Coefficient[Coefficient[POLY,a,i],b,j]


  (*This gets the partial sums for the test and computes their signs*)
  
POSDOM[MATX_]:=Table[Table[POSDOM0[MATX,v,u],{u,1,6}],{v,1,6}]
POSDOM0[MATX_,u_,v_]:=EnhancedSign[Sum[Sum[MATX[[i]][[j]],{i,1,u}],{j,1,v}]]
EnhancedSign[x0_]:=Sign[FullSimplify[x0]];


(*These routines are just for the purpose of seeing numerically what is going on.*)
(*The routine POSDOMDETAIL gives more information than POSDOM because it shows*)
(*The sums and not just their signs*)

POSDOMDETAIL[MATX_]:=Table[Table[POSDOMDETAIL0[MATX,v,u],{u,1,6}],{v,1,6}]
POSDOMDETAIL0[MATX_,u_,v_]:=Sum[Sum[MATX[[i]][[j]],{i,1,u}],{j,1,v}]
