(*This file has the triangle maps from the paper.*)
 (* There is one partition from chapter 5 and one from chapter 6*)
 (*The functions from chapter 5 are P1g0,P1g1,P1g2*)
 (*The functions from chapter 6 are P2g0,P2g1,P2g2*)

Clear[f10,f11,f12,f13,f20,f21,f22,f23];

(*P1g0 is the container for cities 168 and 163*)
(*P1g1 is the container for cities 834 and 839*)
(*P1g2 is the container for cities 836 and 831*)


f10[{x_,y_}]:={x/(1 + Sqrt[5]), (Sqrt[5 - 2 Sqrt[5]] y)/(1 + Sqrt[5])};
f11[{x_,y_}]:= {(2 + 2*Sqrt[5]*x - Sqrt[5]*y)/(2 + 2*Sqrt[5]), 
     (Sqrt[10 - 2*Sqrt[5]]*(2 - 2*x + (2 + Sqrt[5])*y))/(4*(3 + Sqrt[5]))}
f12[{x_,y_}]:= {x + (-1 + (1 + Sqrt[5])/8)*y, (Sqrt[5/8 - Sqrt[5]/8]*y)/2};
f14[{x_,y_}]:={x,x y};
P1g0[{x_,y_}]:=f10[f14[{x,y}]];
P1g1[{x_,y_}]:=f11[f14[{x,y}]];
P1g2[{x_,y_}]:=f12[f14[{x,y}]];

 

(*P2g0 is for the bottom half of state 0*)
(*P2g1 is for the bottom half of state 1*)
(*P2g2 is for the sliver in state1*)
(*P2g3 is for the top half of state 1*)
 
f20[{x_,y_}]:={x/(1 + Sqrt[5]), (Sqrt[5 - 2 Sqrt[5]] y)/(1 + Sqrt[5])};

f21[{x_,y_}]:={1+(-1+1/(1+Sqrt[5])) x,(Sqrt[10-2 Sqrt[5]] y)/(1+Sqrt[5])^2}

  f22[{x_,y_}]:={(4 + 4 Sqrt[5] - 4 Sqrt[5] x - y + Sqrt[5] y)/(4 + 4 Sqrt[5]), (
 Sqrt[10 - 2 Sqrt[5]] (4 x + (-1 + Sqrt[5]) y))/(8 (3 + Sqrt[5]))}
  
  f23[{x_,y_}]:={1/8 (8 + (-5 + Sqrt[5]) x - 2 y), 
 1/16 Sqrt[10 - 2 Sqrt[5]] (x + Sqrt[5] x + y - Sqrt[5] y)}

  f24[{x_,y_}]:={x,x y};

  P2g0[{x_,y_}]:=f20[f24[{x,y}]];
  P2g1[{x_,y_}]:=f21[f24[{x,y}]];
  P2g2[{x_,y_}]:=f22[f24[{x,y}]];
  P2g3[{x_,y_}]:=f23[f24[{x,y}]];

xxx=2
