import java.awt.*;
import java.awt.event.*;
import java.util.Arrays;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;
import java.io.File;


public class PictureCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    Point JX;
    boolean drag;
    Complex SOURCE;
    Complex FARPOINT; 
    PolyFlip HOME;
    PolyFlip[] POLY=new PolyFlip[36];
    int COUNT;
    Complex[] LIST=new Complex[1000];
    int COUNT2;
    Path2D.Double[] ZONE=new Path2D.Double[60];
    boolean FIRSTPAINT;
    Complex[][] MARKER=new Complex[11][2];
    int CITY,STATE;


    public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(480,500,490,490);
	 SOURCE=new Complex(0,0);
	 FARPOINT=new Complex(0,0);
	 POLY=PentagonPlan.main();
         COUNT=26;
	 ZONE=DecagonCities.main();
	 FIRSTPAINT=true;
	 setMarkers();
	 setSource(new Complex(.65,.25));
	 CITY=7;
     }

    /**These are the curve markers*/
    public void setMarkers() {
	double c=Math.cos(-Math.PI/5);
	double s=Math.sin(-Math.PI/5);
	Complex z=new Complex(c,s);
	MARKER[0][0]=new Complex(.19,-.105);
	MARKER[0][1]=Complex.plus(MARKER[0][0],z.scale(.07));
	MARKER[1][0]=new Complex(.41,.198);
	MARKER[1][1]=Complex.plus(MARKER[1][0],z.scale(.07));
	MARKER[2][0]=new Complex(.433,.23);
	MARKER[2][1]=Complex.plus(MARKER[2][0],z.scale(.07));
	MARKER[3][0]=new Complex(.455,.263);
	MARKER[3][1]=Complex.plus(MARKER[3][0],z.scale(.07));
	MARKER[4][0]=new Complex(.42,.185);
	MARKER[4][1]=new Complex(.42,.235);
	MARKER[5][0]=new Complex(.5,.185);
	MARKER[5][1]=new Complex(.5,.235);
	MARKER[6][0]=Formulas.vtx(0);
	MARKER[7][0]=Formulas.vtx(2);
	MARKER[8][0]=Formulas.vtx(3);
    }



    

    /**getting the big plan picture*/
    public PolygonWrapper plan() {
	double a=5.7;
	Complex[] Z={new Complex(-a,0),new Complex(5,0),new Complex(0,a),new Complex(0,-a)};
	return new PolygonWrapper(4,Z);
    }

    
   /**scaling the window*/
    public void scaleNicely() {
	int m=M.C.FIT.mode;
	if(FIRSTPAINT==true) {
	    m=2;
	    FIRSTPAINT=false;
	}
	if(m==0) return;
	scaleNicely(m);
    }

    public void scaleNicely(int m) {
	PolygonWrapper P=new PolygonWrapper();
	if(m==1) P=plan();
	if(m==2) P=centralFace();
	if(m==3) P=DecagonCombinatorics.containingState(SOURCE);
	if(m==4) P=getCurveMarker();
	if(P==null) return;
	Path2D.Double p=P.toPath();
	AffineTransform[] AA=preFit(p,20,20,getWidth()-40,getHeight()-40);
	A[0]=AA[0];
	A[1]=AA[1];
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      scaleNicely();

        if(M.C.DISPLAY.L[4].on==1) drawStateConstruction(g);
        if(M.C.VORONOI.L[4].on==1) drawPlan(g);
	if(M.C.DISPLAY.L[2].on==1) drawCities(g);
        if(M.C.VORONOI.L[0].on==1) drawVoronoi10(g);
        if(M.C.VORONOI.L[1].on==1) drawVoronoi6(g);
	if(M.C.DISPLAY.L[0].on==1) drawCentralFace(g);
	if(M.C.DISPLAY.L[1].on==1) drawStates(g);
        if(M.C.AFMAP.L[1].on==1) drawAFDirection(g);
        if(M.C.VORONOI.L[3].on==1) drawTriplePoints(g);
        if(M.C.AFMAP.L[0].on==1) drawAF(g);
	if(M.C.DISPLAY.L[3].on==1) drawCurveMarker(g);
	if(M.C.AFMAP.L[2].on==1) drawMapConstruction(g);
	if(M.C.DISPLAY.L[5].on==1) drawCityDivider(g);
	if(M.C.VORONOI.L[5].on==1) drawAsterisk(g);
   }

    public void drawCityDivider(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	Complex[] Z1=DecagonCombinatorics.cityDividerUpper();
	Complex[] Z2=DecagonCombinatorics.cityDividerLower();
	p.moveTo(Z1[0].x,Z1[0].y);
	p.lineTo(Z1[1].x,Z1[1].y);
	p.moveTo(Z2[0].x,Z2[0].y);
	p.lineTo(Z2[1].x,Z2[1].y);
	p=transform(p);
	g.setColor(Color.black);
	g.draw(p);

    }

    
    public void drawCurve(Graphics2D g) {
	Color C=Color.black;
	drawCurve(g,1,C);
	drawCurve(g,2,C);
	drawCurve(g,3,C);
	drawCurve(g,4,C);
	drawCurve(g,5,C);
    }


    public void drawCurve(Graphics2D g,int k,Color COL) {
	Complex[] Z=Formulas.curveExtended(k,300);
	PolygonWrapper P=new PolygonWrapper(Z.length,Z);
	Path2D.Double p=P.toPathOpen();
	p=transform(p);
	g.setColor(COL);
	g.draw(p);
    }

    

    

    public void drawCurveMarker(Graphics2D g) {
	PolygonWrapper P=getCurveMarker();
	if(P==null) return;
	Path2D.Double p=new Path2D.Double();
	if(P.count==2) {
	  p=P.toPath();
	}
	if(P.count==3) {
	    p.moveTo(P.z[0].x-.03,P.z[0].y);
	    p.lineTo(P.z[0].x+.03,P.z[0].y);
	    p.moveTo(P.z[0].x,P.z[0].y-.03);
	    p.lineTo(P.z[0].x,P.z[0].y+.03);
	}
        p=transform(p);
	g.setStroke(new BasicStroke(2));
	g.setColor(Color.yellow);
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }
    

    public PolygonWrapper getCurveMarker() {
	int m=-1;
	try{m=M.X.MODE;}
	catch(Exception e) {}
	if(m==0) return getCurveMarker0();
	if(m==1) return getCurveMarker1();
	if(m==2) return getCurveMarker2();
	return null;
    }
    
    public PolygonWrapper getCurveMarker0() {
	int t=-1;
	try{t=M.X.L[0].val;}
	catch(Exception e) {}
	if(t==-1) return null;
	PolygonWrapper P=new PolygonWrapper(2,MARKER[t]);
	return P;
    }

    public PolygonWrapper getCurveMarker1() {
	int t1=-1;
	try{t1=M.X.L[1].val;}
	catch(Exception e) {}
	if(t1==-1) return null;
	int t=t1+6;
	Complex Z0=new Complex(MARKER[t][0].x-.03,MARKER[t][0].y-.03);
	Complex Z1=new Complex(MARKER[t][0].x+.03,MARKER[t][0].y+.03);
	Complex[] ZZ={MARKER[t][0],Z0,Z1};
	PolygonWrapper P=new PolygonWrapper(3,ZZ);
	return P;
    }
    public PolygonWrapper getCurveMarker2() {
	int t1=-1;
	try{t1=M.X.L[2].val;}
	catch(Exception e) {}
	if(t1==-1) return null;
	int t=t1+9;
	Complex Z0=new Complex(MARKER[t][0].x-.03,MARKER[t][0].y-.03);
	Complex Z1=new Complex(MARKER[t][0].x+.03,MARKER[t][0].y+.03);
	Complex[] ZZ={MARKER[t][0],Z0,Z1};
	PolygonWrapper P=new PolygonWrapper(3,ZZ);
	return P;
    }
    
    public void drawCities(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int index=-1;
	Color W=new Color(100,100,100);
	Color[] COL={
	    new Color(40,80,255),
	    new Color(120,180,255),
	    new Color(255,0,0),
	    new Color(200,0,0),
	    new Color(255,100,0),
	    new Color(0,0,220)};

	int a=M.C.getTrans(1);
	for(int i=0;i<60;++i) {
	    int i6=i%6;
	    Color C=COL[i6];
	    C=ColorGenerator.makeTransparent(C,a);
	    if(ZONE[i].contains(SOURCE.x,SOURCE.y)==true) index =i;
	    p=transform(ZONE[i]);
	    g.setColor(C);
   	    g.fill(p);
	    g.setColor(Color.white);
	    g.draw(p);
	}

	if(index==-1) return;
	CITY=index;
	Integer I=new Integer(index);
	M.C.MESSAGE[3]="city "+I.toString();
	int i6=index%6;
	p=transform(ZONE[index]);
	g.setColor(COL[i6]);
   	g.fill(p);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawStates(Graphics2D g) {
	if(STATE==-1) return;
	Path2D.Double p=new Path2D.Double();
	g.setStroke(new BasicStroke(4));
	PolygonWrapper QUAD=new PolygonWrapper(4,DecagonCombinatorics.zone(STATE));
	p=QUAD.toPath();
	p=transform(p);
	g.setColor(Color.black);
  	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawStateConstruction(Graphics2D g) {
	Complex[] w=Decagon.rootsOfUnity5();
        PolygonWrapper P=new PolygonWrapper(5,w);
	Path2D.Double p=P.toPath();
	p=transform(p);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.draw(p);
	
	Color C=new Color(130,200,255);
	
	Complex[] w2={w[0],w[2],w[4],w[1],w[3]};
	P=new PolygonWrapper(5,w2);
	p=P.toPath();
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(1));
	g.draw(p);

	p.reset();
	for(int i=0;i<5;++i) {
	    Complex a=w[i];
	    int j=(i+2)%5;
	    int k=(i+3)%5;
	    Complex b=Complex.plus(w[j],w[k]);
	    b=b.scale(.5);
	    p.moveTo(a.x,a.y);
	    p.lineTo(b.x,b.y);
	}
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(1));
	g.draw(p);

	for(int i=0;i<15;++i) {
	    Complex[] Z=DecagonCombinatorics.zone(i);
	    P=new PolygonWrapper(4,Z);
	    p=P.toPath();
	    p=transform(p);
	    g.setColor(Color.black);
	    g.setStroke(new BasicStroke((float)(1.5)));
	    g.draw(p);
	}
	g.setStroke(new BasicStroke(1));  

    }

    

    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
	g.fillRect(0,0,this.getWidth(),this.getHeight());
    }


    public void drawVoronoi10(Graphics2D g) {
	Complex w=new Complex(SOURCE);
	PolygonWrapper CQ=decagon(w);

	Path2D.Double p=CQ.toPath();
	p=transform(p);
	g.setColor(Color.blue);
	g.draw(p);

	int a=M.C.getTrans(0);

	for(int k=0;k<10;++k) {
	    PolygonWrapper VQ=VoronoiPolygon.cell(CQ.toPoints(),k);
	    p=VQ.toPath();
	    p=transform(p);
	    Color COL=ColorGenerator.COL(k,a);
	    g.setColor(COL);
	    g.fill(p);
	    g.setColor(new Color(255,255,0,a));
	    g.draw(p);
	}

	for(int k=0;k<10;++k) {
	    if(M.C.VORONOI.L[2].on==1) drawLabel(g,k,CQ.z[k]);
	    fillPoint(g,CQ.z[k],.03,Color.black,32);
	}
    }


    public void drawAsterisk(Graphics2D g) {
	Complex w=new Complex(SOURCE);
	PolygonWrapper CQ=decagon(w);
	Path2D.Double p=new Path2D.Double();

	for(int k=0;k<5;++k) {
	    int q=(k+5)%10;
	    Complex z1=Complex.plus(CQ.z[k],CQ.z[q]);
	    z1=z1.scale(.5);
	    Complex z2=Complex.minus(CQ.z[k],CQ.z[q]);
	    Complex z3=Complex.times(z2,new Complex(0,10));
	    Complex z4=Complex.plus(z1,z3);
	    Complex z5=Complex.minus(z1,z3);
	    
	    p.moveTo(z4.x,z4.y);
	    p.lineTo(z5.x,z5.y);
	}
	p=transform(p);
	g.setColor(new Color(255,100,200));
	g.draw(p);
    }



    public static Complex fromPath(Path2D.Double X) {
	AffineTransform A=AffineTransform.getTranslateInstance(0,0);
	PathIterator P=X.getPathIterator(A);
	double[] coords=new double[6];
	int count=0;
	Complex CURRENT=new Complex();
	P.currentSegment(coords);
	CURRENT=new Complex(coords[0],coords[1]);
	return(CURRENT);
    }


    public void drawLabel(Graphics g,int n,Complex z) {
       Integer I=new Integer(n);
       g.setColor(Color.blue);
       double t=A[1].getScaleX();
       int f=(int)(t*.45);
       g.setFont(new Font("Helvetica",Font.PLAIN,f));
       Path2D.Double p=new Path2D.Double();
       p.moveTo(z.x,z.y);
       p=transform(p);
       Complex w=fromPath(p);
       g.drawString(I.toString(),(int)(w.x-f/3),(int)(w.y+f/3));
    }





    public void drawVoronoi6(Graphics2D g) {
	if(STATE==-1) return;
	int[] h=DecagonCombinatorics.hex(STATE);
	Complex[] W=new Complex[6];
	for(int i=0;i<6;++i) {
	    W[i]=Decagon.vertex(h[i],SOURCE);
	    if(M.C.VORONOI.L[2].on==1) drawLabel(g,h[i],W[i]);
	}


	
	PolygonWrapper Q=new PolygonWrapper(6,W);
	int a=M.C.getTrans(0);
	if(a<0) a=0;
	if(a>255) a=255;

	for(int k=0;k<6;++k) {
	    PolygonWrapper VQ=VoronoiPolygon.cell(Q.toPoints(),k);
	    Path2D.Double p=VQ.toPath();
	    p=transform(p);
	    Color COL=ColorGenerator.COL(h[k],a);
	    g.setColor(COL);
	    g.fill(p);
	    g.setColor(new Color(255,255,0,a));
	    g.draw(p);
	}
    }





    
    public void drawSegment(Graphics2D g,Complex[] Z,Color C,int thick) {
	double T=1;
	Path2D.Double p=new Path2D.Double();
        double t=T;
        double x0=(1-t)*Z[0].x + t*Z[1].x;
        double y0=(1-t)*Z[0].y + t*Z[1].y;
	t=1-T;
        double x1=(1-t)*Z[0].x + t*Z[1].x;
        double y1=(1-t)*Z[0].y + t*Z[1].y;
	p.moveTo(x0,y0);
	p.lineTo(x1,y1);
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawCentralFace(Graphics2D g) {
	Complex[] W=new Complex[5];
	for(int i=0;i<5;++i) W[i]=Decagon.rootOfUnity5(i);
	PolygonWrapper P=new PolygonWrapper(5,W);
	Path2D.Double p=P.toPath();
	p=transform(p);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(4));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }
        
    public void drawPlan(Graphics2D g) {
	Color COL=new Color(0,0,0,80);
	for(int i=0;i<COUNT;++i) POLY[i].render(this,g,COL);
    }

    public void locate() {
	int index=0;
	for(int i=0;i<COUNT;++i) {
	    int n=POLY[i].locatePoint(SOURCE);
	    if(n!=-1) index=i;
	}
	if(index!=-1) {
	    System.out.println(index);
	    System.out.println(POLY[index].a[0]+" "+POLY[index].a[1]);
	}
    }

    public void drawDevPoints(Graphics2D g) {
	int test=POLY[0].locatePoint(SOURCE);
	if(test==-1) return;
	Complex[] W=getPoints(SOURCE);
	for(int i=0;i<10;++i) {
	    fillPoint(g,W[i],.015,new Color(0,0,0),16);
	}


    }

    /**This is the map*/
    
    public void drawAF(Graphics2D g) {
	
	Path2D.Double p=new Path2D.Double();
	Complex[] TEST={SOURCE,FARPOINT};
	p.moveTo(SOURCE.x,SOURCE.y);
	p.lineTo(FARPOINT.x,FARPOINT.y);
	g.setStroke(new BasicStroke(4));
	p=transform(p);
	g.setColor(Color.white);
	g.draw(p);
	g.setStroke(new BasicStroke(1));
	getDistDiff(); //computes distance and cross ratio
    }


    /**this gets the difference between the antipodal point
       difference and the farpoint difference*/
    
    public void getDistDiff() {
	double dist=Complex.dist(SOURCE,FARPOINT);
	Double D=new Double(dist);
	M.C.MESSAGE[5]="|p-AF(p)|="+D.toString();

	Complex[] t=MapConstruction.map(CITY);
        Complex z1=Vector.findCross2(SOURCE,FARPOINT,t[1],t[2]);
        Complex z2=Vector.findCross2(SOURCE,FARPOINT,t[0],t[1]);
	double a=z1.x;
	double b=FARPOINT.x;
	double c=SOURCE.x;
	double d=z2.x;
	double[] A={a,b,c,d};
	Arrays.sort(A);
	double cr=((A[0]-A[2])*(A[1]-A[3]))/((A[0]-A[1])*(A[2]-A[3]));
	D=new Double(cr);
	M.C.MESSAGE[6]="C.R.="+D.toString();


    }

    public void drawMapConstruction(Graphics2D g) {
	if(STATE==-1) return;
	Complex[] t=MapConstruction.map(CITY);
	if(t==null) return;
	Complex[] Z=DecagonCombinatorics.zone(STATE);
	PolygonWrapper P=new PolygonWrapper(4,Z);
	MapConstruction.drawMap(this,g,t,P,SOURCE);
    }

    

    public void drawAFDirection(Graphics2D g) {
	if(STATE==-1) return;
	int k=STATE;
	int k1=k%3;
	int k2=(k-k1)/3;
	int[] n={4,3,0};
	int s1=n[k1]+k2;
	Complex e11=Decagon.rootOfUnity5(s1);
	Complex e12=Decagon.rootOfUnity5(s1+1);
	Complex[] E1={e11,e12};
	drawSegment(g,E1,new Color(0,0,255),4);
	drawSegment(g,E1,new Color(0,220,0),2);
	PolygonWrapper Q=DecagonCombinatorics.containingState(SOURCE);
	Complex[] W={SOURCE,FARPOINT};
	W=Q.intersect(W);
	if(W==null) return;
	drawSegment(g,W,new Color(0,0,255),4);
	drawSegment(g,W,new Color(0,220,0),2);
    }

    

    public void drawTriplePoints(Graphics2D g) {
	int[] a=getTriple();
	if(a==null) return;
	Complex[] Z=new Complex[3];
	for(int i=0;i<3;++i) Z[i]=Decagon.vertex(a[i],SOURCE);
	PolygonWrapper Q=new PolygonWrapper(3,Z);
	Path2D.Double p=Q.toPath();
	p=transform(p);
	g.setStroke(new BasicStroke(4));
	g.setColor(new Color(0,0,255));
	g.draw(p);
	g.setStroke(new BasicStroke(2));
	g.setColor(new Color(255,200,0));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    

    

    public void drawCandidatePoints(Graphics2D g) {
	fillPoint(g,SOURCE,.001,new Color(255,255,255,150),64);
	Path2D.Double p=new Path2D.Double();
	int k=STATE;
	if(k!=-1) {
	   int[][] a=DecagonCombinatorics.candidateTriples(k);
	   int index=DecagonCombinatorics.farthestTriple(a,SOURCE);
	   for(int i=0;i<4;++i) {
	      Complex pt=DecagonCombinatorics.triplePoint(a[i],SOURCE);
	      boolean cell=DecagonCombinatorics.isCellVertex(a[i],SOURCE);
	      Color COL=Color.black;
	      if(cell==false) COL=Color.white;
	      double d=.002;
	      fillPoint(g,pt,d,COL,16);
	   }
	}
    }








    public void getFarpoint() {
	Path2D.Double p=new Path2D.Double();
	int[] a=getTriple();
	if(a==null) return;
	FARPOINT=DecagonCombinatorics.triplePoint(a,SOURCE);
	String S="zip ";
	for(int j=0;j<3;++j) {
	    Integer I=new Integer(a[j]);
	    S=S+I.toString();
	}
	try{M.C.MESSAGE[4]=S;}
	catch(Exception e) {}
    }



    public int[] getTriple() {
	Path2D.Double p=new Path2D.Double();
	int k=STATE;
	if(k==-1) return null;
	int[][] a=DecagonCombinatorics.candidateTriples(k);
	int index=DecagonCombinatorics.farthestTriple(a,SOURCE);
	return a[index];
    }
    


    public PolygonWrapper decagon(Complex w) {
	Complex[] W=new Complex[10];
	for(int i=0;i<10;++i) W[i]=Decagon.vertex(i,w);
	PolygonWrapper CQ=new PolygonWrapper(10,W);
	return CQ;
    }

    public PolygonWrapper centralFace() {
	Complex[] W=new Complex[5];
	for(int i=0;i<5;++i) W[i]=Decagon.rootOfUnity5(i);
	PolygonWrapper Q=new PolygonWrapper(5,W);
	return Q;
    }

    public Complex[] getPoints(Complex initial) {
	Complex z=new Complex(initial);
	z.y=-z.y;
	Complex[] W=new Complex[20];
	int count=0;
	
	for(int i=16;i<COUNT;++i) {
	    Complex w0=POLY[i].z;
	    double n=POLY[i].a[1];
	    n=-n+2.5;
	    Complex z1=Complex.times(z,Decagon.rootOfUnity5(n));
	    Complex w1=Complex.plus(z1,w0);
	    W[count]=w1;
	    ++count;
	}
	return W;
    }


    public double trueDistance(Complex z,Complex w) {
	Complex[] W=getPoints(w);
	double d=100;
	for(int i=0;i<10;++i) {
	    double test=Complex.dist(z,W[i]);
	    if(test<d) d=test;
	}
	return d;
    }


    public int[] bestIndices(Complex z,Complex w) {
	Complex[] W=getPoints(w);
	double d=trueDistance(z,w);
	int[] index=new int[10];
	int count=0;
	for(int i=0;i<10;++i) {
	    if(Complex.dist(z,W[i])<d+.00000001) {
		index[count]=i;
		++count;
	    }
	}
	index=ListHelp.trim(index,count);
	return index;
    }


    public Complex map(int j,Complex w) {
	int L=24;
	int k=j+16;
        int m1=POLY[L].a[1];
        int m2=POLY[k].a[1];
	int m=m2-m1;
	double t=2*Math.PI/5;
	double c=Math.cos(m*t);
	double s=Math.sin(m*t);
	Complex z1=Complex.minus(w,POLY[k].z);
	Complex z2=Complex.times(z1,new Complex(c,s));
	Complex z3=Complex.plus(z2,POLY[L].z);
	z3=Complex.minus(z3,POLY[L].z);
	z3.y=-z3.y;
	c=Math.cos(1.5*t);
	s=Math.sin(1.5*t);
	z3=Complex.times(z3,new Complex(c,s));
	return z3;
    }

    
    public void setSource(Point X) {
	Complex z=unTransform(X);
	setSource(z);
    }

    public void setSource(Complex z) {
	STATE=DecagonCombinatorics.stateNumber(z);
	if(STATE==-1) return;
	SOURCE=z;
	Double x=new Double(SOURCE.x);
	Double y=new Double(SOURCE.y);
	getFarpoint();

	try{
	   M.C.MESSAGE[0]=x.toString();
	   M.C.MESSAGE[1]=y.toString();
	   int S=(STATE+12)%15;
	   Integer T=new Integer(S);
           M.C.MESSAGE[2]="state "+T.toString();
	}
	catch(Exception e) {}
    }


  public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e);
        if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,1);
	if(J.mode==2) {
	    setSource(J.X);
	    locate();
	}
	M.repaint();
   }

    public void doTest() {
    }

    public void doMouseClick(int mode) {
        if(mode==1) scaleUp(JX,-1);
	if(mode==3) scaleUp(JX,1);
	if(mode==2) {
	    setSource(JX);
	    locate();
	}
	M.repaint();
   }
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
	if(drag==true) {
	    setSource(J.X);
	}
	M.repaint();
    }

    public void mouseDragged(MouseEvent e) {
         MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    setSource(J.X);
	}
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {

    }

     public void mouseReleased(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

  public void keyTyped(KeyEvent e) {
      char ch=e.getKeyChar();
      if(ch=='z') doMouseClick(1);
      if(ch=='x') doMouseClick(2);
      if(ch=='c') doMouseClick(3);  
      M.repaint();
     }

    public void keyPressed(KeyEvent e) {
	drag=true;
	M.repaint();
    }

    public void keyReleased(KeyEvent e) {
	drag=false;
	M.repaint();
    }

}

