import java.awt.*;
import java.awt.geom.*;

/*This class does the basic arithmetic
  of complex numbers */

public class PolyFlip {
    Complex z; //center
    double r1; //inner radius
    double r2; //outer radius
    int N;     //number of sides
    int n;     //Galois number
    int[] a=new int[2]; //dihedral group element
    Color[] COL=new Color[5];
    int state;


    public PolyFlip() {}

    public PolyFlip(int N0,int n0,int a0,int a1,Complex z0,double r10,double r20,Color[] COL0) {
	this.N=N0;
	this.n=n0;
	this.a[0]=a0;
	this.a[1]=a1;
	this.z=z0;
	this.r1=r10;
	this.r2=r20;
	for(int i=0;i<5;++i) COL[i]=copyColor(COL0[i]);
	this.COL=COL0;
	this.state=0;
    }

    public static Color copyColor(Color C) {
	int r=C.getRed();
	int g=C.getGreen();
	int b=C.getBlue();
	int a=C.getAlpha();
	return new Color(r,g,b,a);
    }
    

    public PolyFlip(PolyFlip Q) {
	this.N=Q.N;
	this.n=Q.n;
        this.a[0]=Q.a[0];
        this.a[1]=Q.a[1];
	this.z=new Complex(Q.z);
	this.r1=Q.r1;
	this.r2=Q.r2;
	for(int i=0;i<5;++i) this.COL[i]=copyColor(Q.COL[i]);
	this.state=Q.state;
    }

    public static PolyFlip basic(int N) {
	Color[] COL=new Color[N];
	for(int i=0;i<N;++i) {
            COL[i]=ColorGenerator.COL(i);
	}

	PolyFlip P=new PolyFlip(N,1,0,0,new Complex(0,0),0,1,COL);
	return P;
    }


    public Path2D.Double wedge(int i) {
	Path2D.Double gp=new Path2D.Double();
	double Pi=Math.PI;
	int j0=(i+a[1])%N;
	int j1=(j0+1)%N;
	double c1=z.x+r1*Math.cos(2*Pi*j0/N);
	double s1=z.y+r1*Math.sin(2*Pi*j0/N);
	double c2=z.x+r1*Math.cos(2*Pi*j1/N);
	double s2=z.y+r1*Math.sin(2*Pi*j1/N);
	double c3=z.x+r2*Math.cos(2*Pi*j0/N);
	double s3=z.y+r2*Math.sin(2*Pi*j0/N);
	double c4=z.x+r2*Math.cos(2*Pi*j1/N);
	double s4=z.y+r2*Math.sin(2*Pi*j1/N);
	if(a[0]==1) {
	    c1=2*z.x-c1;
	    c2=2*z.x-c2;
	    c3=2*z.x-c3;
	    c4=2*z.x-c4;
	}
	gp.moveTo(c1,s1);
	gp.lineTo(c2,s2);
	gp.lineTo(c4,s4);
	gp.lineTo(c3,s3);
	gp.closePath();
	return gp;
    }

    public void render(Graphics2D g,Color C) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<N;++i) {
            int k=(n*i)%N;
	    gp=wedge(i);
	    g.setColor(COL[k]);
	    g.fill(gp);
	    g.setColor(C);
	    g.draw(gp);
	}
    }

    public void render(PictureCanvas P,Graphics2D g,Color C) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<N;++i) {
            int k=(n*i)%N;
	    gp=wedge(i);
	    gp=P.transform(gp);
	    g.setColor(COL[k]);
	    g.fill(gp);
	    g.setColor(C);
	    g.draw(gp);
	}
    }

    public int locatePoint(Complex z) {
	for(int i=0;i<N;++i) {
	    Path2D.Double gp=wedge(i);
	    if(gp.contains(z.x,z.y)==true) {
		state=i;
               return i;
	    }
	}
	return -1;
    }



    public PolyFlip flip(int i) {
	if(a[0]==0) return flip0(i);
	if(a[0]==1) return flip1(i);
	return null;
    }

     public PolyFlip flip0(int i0) {
	 int i=i0+a[1];
	 double pi=Math.PI;
	 double c=r2*Math.cos(2*pi*i/N+pi/N);
	 double s=r2*Math.sin(2*pi*i/N+pi/N);
	 c=c*Math.cos(pi/N);
	 s=s*Math.cos(pi/N);
	 Complex u=new Complex(2*c,2*s);
	 Complex zz=Complex.plus(this.z,u);
	 PolyFlip Q=new PolyFlip(this);
	 Q.z=new Complex(zz);
	 Q.a[0]=1-Q.a[0];
	 Q.a[1]=(-2*i-1+Q.a[1]+3*N)%N;
	 Q.state=-1;
	 return Q;
     }


     public PolyFlip flip1(int i0) {
	 int i=i0+a[1];
	 double pi=Math.PI;
	 double c=r2*Math.cos(2*pi*i/N+pi/N);
	 double s=r2*Math.sin(2*pi*i/N+pi/N);
	 c=c*Math.cos(pi/N);
	 s=s*Math.cos(pi/N);
	 Complex u=new Complex(-2*c,2*s);
	 Complex zz=Complex.plus(this.z,u);
	 PolyFlip Q=new PolyFlip(this);
	 Q.z=new Complex(zz);
	 Q.a[0]=1-Q.a[0];
	 Q.a[1]=(-2*i-1+Q.a[1]+3*N)%N;
	 Q.state=-1;
	 return Q;
     }

    

}
