import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class PolygonWrapper {
    Complex[] z=new Complex[1000];
    int count;


    /**Constructors**/
    public PolygonWrapper() {}

    public PolygonWrapper(int cc,Complex[] zz) {
	this.count=cc;
	for(int i=0;i<cc;++i) {
             z[i]=new Complex(zz[i]);
	}
    }


    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo((z[0].x),(z[0].y));
	for(int i=0;i<count;++i) {
	    gp.lineTo((z[i].x),(z[i].y));
	}
	gp.closePath();
	return(gp);
    }

    public Path2D.Double toPathOpen() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo((z[0].x),(z[0].y));
	for(int i=0;i<count;++i) {
	    gp.lineTo((z[i].x),(z[i].y));
	}
	return(gp);
    }


    public Complex center() {
	Complex w=new Complex();
	for(int i=0;i<count;++i) {
	    w=Complex.plus(w,this.z[i]);
	}
	w.x=w.x/count;
	w.y=w.y/count;
	return(w);
    }


    public Complex[] toPoints() {
	Complex[] w=new Complex[count];
	for(int i=0;i<count;++i) w[i]=new Complex(z[i]);
	return w;
    }
    

    /**gets the intersection with a segment*/
    public Complex[] intersect(Complex[] Z) {
	int count2=0;
	Complex[] W=new Complex[4];
	for(int i=0;i<4;++i) {
	    int j=(i+1)%count;
	    Complex u=Vector.findCross2(Z[0],Z[1],z[i],z[j]);
	    if(Complex.isBetween(u,z[i],z[j])==true) {
		W[count2]=u;
		++count2;
	    }
	}
	if(count2<2) return null;
	return W;
    }


    /**Here is the main convex hull routine**/

    public static PolygonWrapper convexHull(PolygonWrapper P) {
	if(P==null) return(null);
	if(P.count<3) return(null);
	PolygonWrapper Q=new PolygonWrapper();
	int[] n=new int[1000];
        int match;
        int ct;
	for(int i=0;i<P.count;++i) Q.z[i]=new Complex(P.z[i]);
	Q.count=P.count;
        n[0]=bottom(Q);
        match=0;
        ct=0;
	Complex z1=P.z[0];

        while(match==0) {
           n[ct+1]=nextPoint(Q,n[ct]);
	   Complex z0=P.z[n[ct+1]];
           if(n[ct+1]==n[0]) match=1;
           if(ct>=P.count) match=1;
           if(n[ct+1]==-1) match=1;
           Q=roll(Q,n[ct],n[ct+1]); 
           ++ct;
	}
	for(int i=0;i<ct;++i) 	Q.z[i]=P.z[n[i]];
	Q.count=ct;
	return(Q);
    }




    

    /*given a polygon with a horizontal edge,
      this routine finds the point immediately
      counterclockwise from the edge*/

    public static int nextPoint(PolygonWrapper P,int n) {
      double test,min;
      Complex ONE=new Complex(1,0);
      Complex w=new Complex();
      int index=-1;
      min=10000000;
      for(int i=0;i<P.count;++i) {
         if(i!=n) {
           w=Complex.minus(P.z[i],P.z[n]);
	   if(w.norm()>.0000000001) {
             w=Complex.unit(w);
             test=Complex.dist(w,ONE);
             if(test<min) {
               min=test;
               index=i;
	     }
	   }
	 }
      }
      return(index);
    }


    /*this routine rotates a polygon so that
      the edge determined by the indices a and b
      is horizontal*/


     public static PolygonWrapper roll(PolygonWrapper P,int a,int b) {
        Complex w=new Complex();
        PolygonWrapper Q=new PolygonWrapper();
        w=Complex.minus(P.z[b],P.z[a]);
        w=Complex.unit(w);
        for(int i=0;i<P.count;++i) {
           Q.z[i]=Complex.divide(P.z[i],w);
	}
        Q.count=P.count;
        return(Q);
     }


    /**Finds the bottom most point of the polygon**/

     public static int bottom(PolygonWrapper P) {
       double test,min;
       int X=-1;
       min=10000.0;
       for(int i=0;i<P.count;++i) {
         test=P.z[i].y;
         if(test<min) {
            X=i;
	    min=test;;
	 }
       }
       return(X);
     }

}
