import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    Dodecahedron D;
    ControlPanel[] DISPLAY=new ControlPanel[2];
    ControlPanel AUTO;
    ListenSquare TEST,CLEAR;
    Complex[] POINT=new Complex[1000000];
    Color[] COL=new Color[1000000];
    int COUNT=0;
    Lever POINTSIZE;
    Lever PLOTNUM;
    Lever GOOD;
    
     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setPanels();
	 setScales(10,410,225);
	 TEST=new ListenSquare(220,95,50,20);
	 CLEAR=new ListenSquare(290,95,50,20);
	 POINTSIZE=new Lever(220,20,2,8);
	 PLOTNUM=new Lever(220,60,4,8);
	 
	 GOOD=new Lever(127,135,0,15);
     }



    
    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};


	String[] DisplayString={"faces","vertices","key edges","segment","bisector 1","bisector 2","quad","display"};
	int[] DisplayState={1,1,0,0,0,0,0};
        DISPLAY[0]=new ControlPanel(C0,DisplayString,DisplayState,7);
        DISPLAY[1]=new ControlPanel(C0,DisplayString,DisplayState,7);

	String[] AutoString={"no","yes","auto test"};
	int[] AutoState={1,0};
        AUTO=new ControlPanel(C0,AutoString,AutoState,2);
    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawPlot(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,80,80));
      g.fillRect(0,0,getWidth(),getHeight());
      g.setColor(Color.white);
      g.fillRect(0,170,getWidth(),getHeight()-170);
    }


    public void drawPlot(Graphics2D g) {
	Color C1=Color.white;
	Color C2=new Color(0,0,0,0);
	Color C3=new Color(255,120,0);
	Color C4=new Color(255,0,255);
	
	drawSquare(g,0,C1,Color.black);

	double size=.1*Math.pow(Math.sqrt(.5),POINTSIZE.val+5);
	
	for(int i=0;i<COUNT;++i) {
	    fillPoint(g,POINT[i],size,COL[i],8);
	}
	drawSquare(g,0,C2,Color.black);
	drawSquare(g,1.1,C2,Color.black);
    }

    public void drawSpecial17(Graphics2D g) {
	  Path2D.Double p=new Path2D.Double();
	  double t=(5+Math.sqrt(5))/10;
	  p.moveTo(0,t);
	  p.lineTo(1,t);
	  p.moveTo(1.1,t);
	  p.lineTo(2.1,t);
	  p=transform(p);
	  g.setColor(new Color(200,0,200));
	  g.draw(p);
    }

    public void drawSpecial18(Graphics2D g) {
	  Path2D.Double p=new Path2D.Double();
	  double t=1-(5+Math.sqrt(5))/10;
	  p.moveTo(1.1+t,0);
	  p.lineTo(1.1+t,1);
	  p=transform(p);
	  g.setColor(new Color(200,0,200));
	  g.draw(p);
    }


    public void drawSquare(Graphics2D g, double x,Color C1,Color C2) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(x,0);
	p.lineTo(x+1,0);
	p.lineTo(x+1,1);
	p.lineTo(x,1);
	p.closePath();
	p=transform(p);
	g.setColor(C1);
	g.fill(p);
	g.setColor(C2);
	g.draw(p);
    }
    
    public void drawControls(Graphics2D g) { 
      DISPLAY[0].render2(g,415,0,80);
      DISPLAY[1].render2(g,0,0,80);
      AUTO.render2(g,90,0,70);
      TEST.render(g,"test",16,0,new Color(0,160,0));
      CLEAR.render(g,"reset",16,0,Color.blue);
      POINTSIZE.render2(g,"point size",new Color(0,100,0));
      PLOTNUM.render2(g,"plot number",new Color(0,100,0));
      GOOD.render2(g,"good chains",new Color(200,0,200));
    }

    public int compressingData(int k) {
	int[] t={0,4,5,3,1,1,0,0,0,0,5,5,6,3,2,3,1,3,4,1,1,1,1,1,1,1};
	return t[k];
    }


    public void selectChain(Point X) {
	GOOD.process(X);
	if(GOOD.isUsed(X)!=-1) {
	    if(AUTO.mode==1) doTest();
	}
    }
	
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	selectChain(J.X);
	repaint();
	DISPLAY[0].toggle(J.X);
	DISPLAY[1].toggle(J.X);
	POINTSIZE.process(J.X);
	AUTO.switchMode(J.X);
	PLOTNUM.process(J.X);
	if(TEST.inside(J.X)==1) doTest();
	if(CLEAR.inside(J.X)==1) COUNT=0;
	M.repaint();
    }


    public void doTest() {
	COUNT=0;
	Chain c0=M.P0.CH[GOOD.val];
	Complex[] U=QuadTest.directQuad(c0);
	double lim=Math.pow(2,PLOTNUM.val+2);
	boolean lengthShrink=false;
	boolean pathExist=false;
	
	for(int i=0;i<=lim;++i) {
	    for(int j=0;j<=lim;++j) {
		lengthShrink=false;
		pathExist=false;
		
		double a=1.0*i/lim;
		double b=1.0*j/lim;
	        Complex u1=Complex.plus(U[0].scale(1-a),U[1].scale(a));
	        Complex u2=Complex.plus(U[2].scale(1-b),U[3].scale(b));
		
	        Complex[] CHORD={u1,u2};
		
	        pathExist=c0.checkCross(CHORD);
	          POINT[COUNT]=new Complex(a+1.1,b);
		  if(pathExist==true) COL[COUNT]=new Color(1480,180,180);
		  if(pathExist==false) COL[COUNT]=Color.blue;
	          ++COUNT;
	    }
	}
    }

    
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 

}

