import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    int TYPE;
    Manager M;
    Path2D.Double TRI;
    Color COLOR;
    Dodecahedron D;
    PolygonWrapper[] P=new PolygonWrapper[10];
    int COUNT=0;
    int CHOICE;
    Chain[] CH=new Chain[50];
    double[] T=new double[2];

     public PictureCanvas(int type) {
	 TYPE=type;
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(250,250,30);
	 D=new Dodecahedron();
	 CHOICE=0;
	 setChain();
	 T[0]=.5;
	 T[1]=.5;

     }


    public void setChain() {
	CH=ChainList.setChain();
	CH=ChainList.setChain();
	COUNT=CH.length;
    }
    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      int r=getChoice();
      Chain c=CH[r];
      if(getDisplay(0)==1) drawPenta(g,c);
      if(getDisplay(2)==1) drawEdges(g,c);
      if(getDisplay(3)==1) drawSegment(g,c);
      if(getDisplay(1)==1) drawVertices(g,c);
   }


    public int getDisplay(int k) {
	int t=1;
	try{
	  t=M.C.DISPLAY[TYPE].L[k].on;
	}
	catch(Exception e) {t=1;}
	return t;
    }

    

    public int getChoice() {
	int r=0;
	try {
	  r=M.C.GOOD.val;
	}
	catch(Exception e) {}
	return r;
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight()); 
	double t=A[1].getScaleX();
	Integer T=new Integer(getScale());
	g.setColor(Color.black);
         g.setFont(new Font("Helvetica",Font.PLAIN,15));
	 g.drawString(T.toString(),5,20);
    }

    public int getScale() {
	double t=A[1].getScaleX();
	t=t/30;
	t=t*t*t*t;
	t=Math.log(t)/Math.log(2);
	if(t>-.00001) return (int)(t+.01);
	t=-t;
	int k=(int)(t+.01);
	return -k;
    }



    public void drawPenta(Graphics2D g,Chain c) {
	for(int i=0;i<c.COUNT;++i) {
	    drawPenta0(g,c.P[i]);
	}
    }

    public void drawEdges(Graphics2D g,Chain c) {

	for(int i=0;i<c.COUNT-1;++i) {
	    if(c.Z[i]!=null) {
              PolygonWrapper P=new PolygonWrapper(2,c.Z[i]);
              Path2D.Double p=P.toPath();
	      p=transform(p);
	      g.setStroke(new BasicStroke(3));
	      g.setColor(Color.blue);
	      g.draw(p);
	    }
	    else {
		System.out.println("null "+i);
	    }
	}
	g.setStroke(new BasicStroke(1));
    }

    public void drawVertices(Graphics2D g,Chain c) {
	for(int i=0;i<c.COUNT;++i) {
	    drawVertices0(g,c.P[i]);
	}
    }



        
    public void drawPenta0(Graphics2D g,PolygonWrapper P) {
	Path2D.Double p=P.toPath();
	p=transform(p);
	Color C=D.faceColor(P.name);
	g.setColor(C);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
	int n=P.name;
	drawLabel(g,n,P.center());
    }

    
    public void drawVertices0(Graphics2D g,PolygonWrapper P) {
	Color[] COL={Color.white,Color.black,new Color(220,0,0),Color.blue,Color.magenta};
	for(int i=0;i<5;++i) {
	    fillPoint(g,P.z[i],.15,Color.black,100);
	    fillPoint(g,P.z[i],.13,COL[P.z[i].tag],100);
	}
    }



    public void drawSegment(Graphics2D g,Chain c) {
	int L=c.COUNT-2;
	Complex[] zz=c.getSegment(T);
	Complex z1=zz[0];
	Complex z2=zz[1];
	Path2D.Double p=new Path2D.Double();
	p.moveTo(z1.x,z1.y);
	p.lineTo(z2.x,z2.y);
	p=transform(p);
	g.setColor(Color.blue);
	g.draw(p);
    }

    public static Complex fromPath(Path2D.Double X) {
	AffineTransform A=AffineTransform.getTranslateInstance(0,0);
	PathIterator P=X.getPathIterator(A);
	double[] coords=new double[6];
	int count=0;
	Complex CURRENT=new Complex();
	P.currentSegment(coords);
	CURRENT=new Complex(coords[0],coords[1]);
	return(CURRENT);
    }


    public void drawLabel(Graphics g,int n,Complex z) {
       Integer I=new Integer(n);
       g.setColor(Color.black);
       double t=A[1].getScaleX();
       int f=(int)(t*.7);
       g.setFont(new Font("Helvetica",Font.PLAIN,f));
       Path2D.Double p=new Path2D.Double();
       p.moveTo(z.x,z.y);
       p=transform(p);
       Complex w=fromPath(p);
       g.drawString(I.toString(),(int)(w.x-f/3),(int)(w.y+f/3));
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	repaint();
    }



    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }

    


}

