import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class QuadTest {

    public static int[] compressingSet(Chain c1,Chain[] C0) {
	int count=0;
	int[] t=new int[C0.length];

	for(int i=0;i<C0.length;++i) {
	    boolean test=isCompressing(c1,C0[i]);
	    if(test==true) {
		t[count]=i;
		++count;
	    }
	}
	int[] t2=new int[count];
	for(int i=0;i<count;++i) t2[i]=t[i];
	return t2;
    }




    public static boolean isCompressing(Chain c1,Chain c0) {
	double[] d= distanceProfile(c1,c0);
	for(int i=0;i<4;++i) {
	    if(d[i]<0) return false;
	}
	return true;
    }

    public static double[] distanceProfile(Chain c1,Chain c0) {
	double[] d=new double[4];
	Complex[] Q=directQuad(c1);
	Complex[] R=derivedQuad(c1,c0);
	return distanceProfile(Q,R);
    }

    public static double[] distanceProfile(Complex[] Q,Complex[] R) {
	double[] d=new double[4];
	int count=0;
	for(int i=0;i<2;++i) {
	    for(int j=2;j<4;++j) {
		double d0=Complex.dist(R[i],R[j]);
		double d1=Complex.dist(Q[i],Q[j]);
	        d[count]=d1-d0;
		if(Math.abs(d[count])<.000000000001) d[count]=0;
	        ++count;
	    }
	}
	return d;
    }


    public static Complex[] directQuadFull(Chain c1) {
	int L=c1.COUNT-2;
	Complex[] Q={c1.Z[0][0],c1.Z[0][1],c1.Z[L][1],c1.Z[L][0]};
	return Q;
    }
    
    public static Complex[] directQuad(Chain c1) {
	int L=c1.COUNT-2;
	Complex[] Q={c1.Z[0][0],c1.Z[0][1],c1.Z[L][1],c1.Z[L][0]};
	//Q[0]=Complex.plus(Q[0].scale(2.0/3),Q[1].scale(1.0/3));
	return Q;
    }


    public static Complex[] derivedQuad(Chain c1,Chain c0) {
	Complex[] Q=directQuadFull(c1);
	Complex[] R=new Complex[4];
	for(int i=0;i<4;++i) {
	    int test=getTag(Q[i],c1);
	    if(i<2) R[i]=getPoint(0,c0,test);
	    if(i>1) R[i]=getPoint(c0.COUNT-1,c0,test);
	}
	//	R[0]=Complex.plus(R[0].scale(2.0/3),R[1].scale(1.0/3));
	return R;
    }


    public static int getTag(Complex z,Chain c) {
	for(int i=0;i<c.COUNT;++i) {
	    for(int j=0;j<5;++j) {
		Complex w=c.P[i].z[j];
		int t=c.P[i].z[j].tag;
		if(Complex.dist(z,w)<.0000001) return t;
	    }
	}
	return -1;
    }

    public static Complex getPoint(int L,Chain c,int tag) {
	for(int i=0;i<5;++i) {
	    if(c.P[L].z[i].tag==tag) return c.P[L].z[i];
	}
	return null;
    }





}
