import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.math.*;

public class Chain {
    PolygonWrapper[] P=new PolygonWrapper[10];
    Complex[][] Z=new Complex[10][2];
    int[] B;
    int COUNT;

    public Chain() {}

    public static Chain setChain(int[] a) {
	Dodecahedron D=new Dodecahedron();
	Chain C=new Chain();
	C.P[0]=D.bottom();
	
	for(int i=0;i<a.length;++i) { 
            int m=D.BOTTOM;
	    D.roll(a[i]);  
            int n=D.BOTTOM;
	    C.P[i+1]=D.bottom();
	    C.Z[i]=D.edge(m,n);

	}
	C.COUNT=a.length+1;
	C.B=new int[a.length];
	for(int i=0;i<a.length;++i) C.B[i]=a[i];
	return C;
    }



    public static int[] convert(int[] a) {
	Dodecahedron D=new Dodecahedron();
	int[] b=new int[a.length+1];
	int init=0;

	for(int i=0;i<a.length;++i) {
	    int[] t=D.A[init];
	    int u=t[a[i]];
	    b[i]=u;
	    init=u;
	}
	b=trimZeros(b);
	return b;

    }


    public static int[] trimZeros(int[] b) {
	int zero=-1;
	for(int i=b.length-1;i>0;--i) {
	    if(b[i]==0) zero=i;
	}
	if(zero==-1) return b;
	int[] c=new int[zero];
	for(int i=0;i<c.length;++i) c[i]=b[i];
	return c;
    }

    public static int[] rotate(int k,int[] a) {
	int[] b=new int[a.length];
	for(int i=0;i<a.length;++i) {
	    if(a[i]==0) b[i]=0;
	    if(a[i]==11) b[i]=11;
	    if((a[i]>0)&&(a[i]<6)) b[i]=1+(a[i]-1+k)%5;
	    if((a[i]>5)&&(a[i]<11)) b[i]=6+(a[i]-6+k)%5;
	}
	return b;
    }

    public static int[] trim(int[] a) {
	int s=first11(a);
	if(s==-1) return null;
	if(a[s+1]!=9) return null;
	int[] b=new int[s+2];
	for(int i=0;i<b.length;++i) b[i]=a[i];
	return b;
    }
    
    public static int first11(int[] a) {
	for(int i=0;i<a.length-1;++i) {
	    if(a[i]==11) return i;
	}
	return -1;
    }

    public static int[] base5(int k,int n) {
	int[] x=new int[k];
	int m=n;
	for(int count=0;count<k;++count) {
	    x[k-1-count]=m%5;
	    m=(m-x[k-1-count])/5;
	}
	return(x);
    }



    public static boolean isGoodLong(int[] b) {
	if(b==null) return false;
	if(repeaterLong(b)==true) return false;
	Chain C=setChain(b);
	return true;
    }

    public static boolean isGoodShort(int[] b) {
	if(b==null) return false;
	if(b.length<2) return false;
	if(repeaterShort(b)==true) return false;
	if(reachesTop(b)==true) return false;
	if(b[b.length-1]!=9) return false;
	return true;
    }
    


    public static boolean repeaterShort(int[] b) {
	if(b[1]==0) return true;
	if(b.length>2) {
	   if((b[1]<6)&&(b[2]<6)) return true;
	}
	for(int i=0;i<b.length-2;++i) {
	    if(b[i]==b[i+2]) return true;
	    if((b[i]>5)&&(b[i+1]<6)) return true;
	}
	return false;
    }



    public static boolean repeaterLong(int[] b) {
	if(b[1]==0) return true;
	if(b.length>2) {
	   if((b[1]<6)&&(b[2]<6)) return true;
	}
	for(int i=0;i<b.length-2;++i) {
	    if(b[i]==b[i+2]) return true;
	}
	return false;
    }



    

    public static boolean reachesTop(int[] b) {
	for(int i=0;i<b.length;++i) {
	    if(b[i]==11) return true;
	}
	return false;
    }



    /**crossing tests*/

    public Complex[] getSegment(double[] T) {
	int L=COUNT-2;
	Complex z1=Complex.plus(Z[0][0].scale(1-T[0]),Z[0][1].scale(T[0]));
	Complex z2=Complex.plus(Z[L][0].scale(1-T[1]),Z[L][1].scale(T[1]));
	Complex[] zz={z1,z2};
	return zz;
    }

    public boolean checkCrossRandom(int N) {
	for(int i=0;i<N;++i) {
	    double[] T={randomPinched(),randomPinched()};
	    boolean test=checkCross(T);
	    if(test==true) {
		return true;
	    }
	}
	return false;
    }

    public boolean checkCross(double[] T) {
	return checkCross(getSegment(T));
    }

    
    public boolean checkCross(Complex[] W) {
	for(int i=0;i<COUNT-1;++i) {
	    boolean test=Vector.checkCross(W[0],W[1],Z[i][0],Z[i][1]);
	    if(test==false) return false;
	}
	return true;
    }

    public double randomPinched() {
	double t=.001+.998*Math.random();
	return t;
    }


    public void print() {
	System.out.print("{");
	for(int i=0;i<COUNT-1;++i) {
	    if(i<COUNT-2) System.out.print(B[i]+",");
	    if(i==COUNT-2) System.out.print(B[i]+"}");
	}
	System.out.print(",");
    }


    
}


