import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Dodecahedron {
    Vector[] V=new Vector[20];
    int[][] F=new int[12][5];
    int[][] A=new int[12][5]; //adjacency list
    int BOTTOM;


    public Dodecahedron() {
	double phi1=(1+Math.sqrt(5))/2;
	double phi2=1/phi1;
	Vector A=new Vector(1.0,1.0,1.0);
	Vector B1=new Vector(phi1,phi2,0.0);
	Vector B2=new Vector(0.0,phi1,phi2);
	Vector B3=new Vector(phi2,0.0,phi1);
	
	int count=0;
	
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<2;++k) {
		    V[count]=negate(i,j,k,A);
		    ++count;
		}
	    }
	}

	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
	       V[count]=negate(i,j,1,B1);
	       ++count;
	    }
	}

	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		V[count]=negate(1,i,j,B2);
	       ++count;
	    }
	}

	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		V[count]=negate(i,1,j,B3);
	       ++count;
	    }
	}

	assignFaces();
	normalize();
	setColors();
	BOTTOM=0;
    }


    public void setColors() {
	int[][] t={{0,10,14,17},{5,8,15,18},{1,2,4,7},{3,11,13,16},{6,9,12,19}};
	for(int i=0;i<5;++i) {
	    for(int j=0;j<4;++j) {
		V[t[i][j]].tag=i;
	    }
	}
    }


    
    public void normalize() {

	double phi1=(Math.sqrt(5)+1)/2;
	double a=phi1/2;
	for(int i=0;i<20;++i) V[i]=V[i].scale(a);
	double b=2*Math.sin(Math.PI/5);
	for(int i=0;i<20;++i) V[i]=V[i].scale(b);

	Vector W=new Vector(0,0,0);
	for(int i=0;i<5;++i) {
	    W=Vector.plus(W,V[F[0][i]]);
	}
	W=W.scale(1.0/5);
	for(int i=0;i<20;++i) {
	    V[i]=Vector.minus(V[i],W);
	}

	Vector A=new Vector(V[0]);
	Vector B=Vector.cross(V[0],V[1]);
	Vector C=Vector.cross(B,A);
	C=C.scale(1/C.norm());
	Matrix M=Matrix.fromFrameInverse(A,C);
	for(int i=0;i<20;++i) V[i]=M.act(V[i]);
	for(int i=0;i<20;++i) V[i].x[2]=-V[i].x[2];
    }

    

    
    

    public void assignFaces() {

	int[][] FF={{0,8,1,13,12},//0
		    {16,2,9,8,0}, //1
		    {1,8,9,3,17}, //2
		    {17,19,5,13,1}, //3
		    {12,13,5,10,4}, //4
                    {0,12,4,18,16}, //5
		    {19,7,11,10,5}, //6
		    {4,10,11,6,18}, //7
		    {2,16,18,6,14}, //8
		    {3,9,2,14,15}, //9
		    {3,15,7,19,17}, //10
	            {6,11,7,15,14}}; //11

	for(int i=0;i<12;++i) {
	    for(int j=0;j<5;++j) {
		F[i][j]=FF[i][j];
	    }
	}

	int[][] AA={{1,2,3,4,5},
                   {0,2,5,8,9},
                   {0,1,3,9,10},
                   {0,2,4,6,10},
                   {0,3,5,6,7},
                   {0,1,4,7,8},
                   {3,4,7,10,11},
                   {4,5,6,8,11},
                   {1,5,7,9,11},
                   {1,2,8,10,11},
                   {2,3,6,9,11},
                   {6,7,8,9,10}};

	for(int i=0;i<12;++i) {
	    for(int j=0;j<5;++j) {
		A[i][j]=AA[i][j];
	    }
	}
    }

    

    public static Vector negate(int i,int j,int k,Vector V) {
	Vector W=new Vector(V);
	if(i==1) W.x[0]=-W.x[0];
	if(j==1) W.x[1]=-W.x[1];
	if(k==1) W.x[2]=-W.x[2];
	return W;
    }


    public Vector faceCenter(int q) {
	Vector W=new Vector(0,0,0);
	for(int i=0;i<5;++i) W=Vector.plus(W,V[F[q][i]]);
	W=W.scale(.2);
	return W;
    }

    public Vector center() {
	Vector W=new Vector(0,0,0);
	for(int i=0;i<20;++i) W=Vector.plus(W,V[i]);
	W=W.scale(.05);
	return W;
    }

    public Complex[] bottomFace() {
	int b=BOTTOM;
	Complex[] Z=new Complex[5];
	for(int i=0;i<5;++i) {
	    Vector W=V[F[b][i]];
	    Z[i]=new Complex(W.x[0],W.x[1]);
	}
	return Z;
    }

    public Complex[] edge(int a,int b) {
	int[] e=getEdge(a,b);
	if(e==null) return null;
	Complex[] z=new Complex[2];
	z[0]=new Complex(V[e[0]].x[0],V[e[0]].x[1]);
	z[1]=new Complex(V[e[1]].x[0],V[e[1]].x[1]);
	return z;
    }


    
    public int[] getEdge(int a,int b) {
	int[] A=F[a];
	int[] B=F[b];
	for(int i0=0;i0<5;++i0) {
	    for(int j0=0;j0<5;++j0) {
		int i1=(i0+1)%5;
		int j1=(j0+4)%5;
		if((A[i0]==B[j0])&&(A[i1]==B[j1])) {
		    int[] E={A[i0],A[i1]};
		    return E;
		}
	    }
	}
	return null;
    }

    public void print() {
	for(int i=0;i<20;++i) V[i].print();
    }
    
    public void printFace(int q) {
	for(int i=0;i<5;++i) V[F[q][i]].print();
    }


    public Vector[] frame(int[] e,int f) {
	Vector A=Vector.minus(V[e[0]],V[e[1]]);
	Vector B=Vector.minus(faceCenter(f),V[e[0]]);
	Vector C=Vector.cross(A,B);
	Vector D=Vector.cross(C,A);
	Vector[] X={A,D};
	return X;
    }


    public void roll(int a) {
	int[] e=getEdge(BOTTOM,a);
	if(e==null) return;
	Vector[] A0=frame(e,BOTTOM);
	Vector[] A1=frame(e,a);
	A0[1]=A0[1].scale(-1);
      	A1[0]=A1[0].scale(-1);

	
	Matrix M0=Matrix.fromFrameInverse(A0[0],A0[1]);
	Matrix M1=Matrix.fromFrame(A1[0],A1[1]);
	Vector[] W=new Vector[20];
	for(int i=0;i<20;++i) W[i]=Matrix.act(M0,V[i]);
	for(int i=0;i<20;++i) W[i]=Matrix.act(M1,W[i]);
	
	Vector TRANS=Vector.minus(W[e[1]],V[e[0]]);
	for(int i=0;i<20;++i) {
	    W[i]=Vector.minus(W[i],TRANS);
	    W[i].tag=V[i].tag;
	}
	for(int i=0;i<20;++i) V[i]=new Vector(W[i]);
	BOTTOM=a;
	reflect(e);
    }

    public void reflect(int[] e) {
	Vector R=Vector.minus(V[e[0]],V[e[1]]);
        R=R.unit();
	Vector[] W=new Vector[20];
	for(int i=0;i<20;++i) {
            double d=Vector.dot(R,V[i]);
	    W[i]=Vector.minus(V[i],R.scale(2*d));
	    W[i].tag=V[i].tag;
	}
	Vector TRANS=Vector.minus(W[e[0]],V[e[1]]);
	for(int i=0;i<20;++i) {
	    V[i]=new Vector(W[i]);
	    V[i]=V[i].minus(V[i],TRANS);
	    V[i].tag=W[i].tag;
	}
    }

    public Vector[] stereo() {
	Vector C=this.center();
        double test=Vector.dist3D(C,V[0]);
	C=new Vector(0,0,2*test);
	
	Vector[] W=new Vector[20];
	for(int i=0;i<20;++i) {
	    double t=1/(C.x[2]-V[i].x[2]);
	    W[i]=Vector.plus(C.scale(1-t),V[i].scale(t));
	}
	return W;
    }


    public PolygonWrapper bottom() {
	Complex[] Z=new Complex[5];
	for(int i=0;i<5;++i) {
	    Vector W=new Vector(this.V[F[BOTTOM][i]]);
	    Z[i]=new Complex(W.x[0],W.x[1]);
	    Z[i].tag=W.tag;
	}
	PolygonWrapper P=new PolygonWrapper(5,Z);
	P.name=BOTTOM;
	return P;
    }

    public Color faceColor(int b) {
	Color C=new Color(220,220,220);
	if((b>0)&&(b<6)) C=new Color(255,255,0);
	if((b>5)&&(b<11)) C=new Color(0,200,0);
	if(b==11) C=new Color(255,100,0);
	return C;
    }

}




