import java.awt.event.*;
import java.awt.*;


public class SegmentTest {

    /**This routine returns false if the
       chain does not support a filling line segment.*/

    public static boolean main(Chain c) {
	int L=c.COUNT-2;
	for(int i=L;i>2;--i) {
	  boolean test=intersectionTest(c,i);
	  if(test==false) return false;
	}
	return true;
    }

    public static boolean intersectionTest(Chain c,int L) {
	for(int k=1;k<L;++k) {
	    boolean test=intersectionTest(c,L,k);
	    if(test==false) return false;
	}
	return true;
    }

    public static boolean intersectionTest(Chain c,int L,int k) {
	boolean pos=false;
	boolean neg=false;
	for(int a=0;a<2;++a) {
	    for(int b=0;b<2;++b) {
		int test=intersectionSign(c,L,k,a,b);
		if(test==-1) neg=true;
		if(test==+1) pos=true;
		if(test==0) return true;
	    }
	}
	if((pos==true)&&(neg==false)) return false;
	if((neg==true)&&(pos==false)) return false;
        return true;
    }

    public static int intersectionSign(Chain c,int L,int k,int a,int b) {
	Complex[] Z={c.Z[0][a],c.Z[L][b]};
	Complex[] W={c.Z[k][0],c.Z[k][1]};
	int a0=Complex.orientationWeak(Z[0],Z[1],W[0]);
	int a1=Complex.orientationWeak(Z[0],Z[1],W[1]);
	if(a0+a1<0) return -1;
	if(a0+a1>0) return 1;
	return 0;
    }


}


