import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.math.*;

public class Chain {
    PolygonWrapper[] P=new PolygonWrapper[10];
    Complex[][] Z=new Complex[10][2];
    int[] B;
    int COUNT;

    public Chain() {}

    public static Chain setChain(int[] a) {
	Dodecahedron D=new Dodecahedron();
	Chain C=new Chain();
	C.P[0]=D.bottom();
	
	for(int i=0;i<a.length;++i) { 
            int m=D.BOTTOM;
	    D.roll(a[i]);  
            int n=D.BOTTOM;
	    C.P[i+1]=D.bottom();
	    C.Z[i]=D.edge(m,n);

	}
	C.COUNT=a.length+1;
	C.B=new int[a.length];
	for(int i=0;i<a.length;++i) C.B[i]=a[i];
	return C;
    }


    public Chain rotate(int k) {
	int[] b=new int[B.length];
	for(int i=0;i<B.length;++i) {
	    b[i]=B[i];
	    if((B[i]>0)&&(B[i]<6)) b[i]=(B[i]-1+k)%5+1;
	    if((B[i]>5)&&(B[i]<11)) b[i]=(B[i]-6+k)%5+6;
	}
	return setChain(b);
    }

    /**transplanting complex numbers.  Note  the multiplication
       by the 5th root of unity w^2, which comes from the way that our
       coloring interacts with the antipodal map*/


    public Complex transplant(Complex z0) {
	Complex z=Complex.times(z0,rootOfUnity5(2)); 
	int L=COUNT-1;
	Complex c=P[L].center();
        Complex w=new Complex(1,0);
	for(int i=0;i<5;++i) {
	    if(P[L].z[i].tag==0) w=P[L].z[i];
	}
	w=Complex.minus(w,c);
	Complex w1=Complex.times(w,z.conjugate());
	Complex w2=Complex.plus(w1,c);
	return w2;
    }

    public double dist(Complex[] z) {
	Complex w1=transplant(z[1]);
	Complex[] w={z[0],w1};
	return Complex.dist(w[0],w[1]);
    }

    public static Complex rootOfUnity5(int k) {
	double a=2*k*Math.PI/5;
	double c=Math.cos(a);
	double s=Math.sin(a);
	return new Complex(c,s);
    }
    

    public void print() {
	System.out.print("{");
	for(int i=0;i<COUNT-1;++i) {
	    if(i<COUNT-2) System.out.print(B[i]+",");
	    if(i==COUNT-2) System.out.print(B[i]+"}");
	}
	System.out.print(",");
    }

}


