import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ChainCompete {

    /**GETTING THE CHAINS*/
    
    /**gets the (i,j)th chain.  There are 14 chains on the list and 5 possible rotations*/
    
    public static Chain getChain(int i,int j) {
	Chain c=getChain0(j);
	c=c.rotate(i);
	return c;
    }
    
    public static Chain getChainFocused(int k) {
	return getChainBad(k);
    }


    public static Chain getChainBad(int k) {
	int[][] b={{1,2,10,11},{3,10,6,11},{2,10,6,11},{3,6,10,11},{1,2,10,6,11},{1,9,10,11},{1,5,7,11},{5,4,6,11},{5,7,6,11},{1,5,7,6,11},{5,1,8,11},{1,5,8,11},{5,1,9,11},{5,1,9,10,11},{4,6,10,11},{5,4,6,10,11}};
    int[] B=b[k];
    Chain c=Chain.setChain(B);
    return c;
    }


    public static Chain getChain0(int k) {
	int[][] b={{1,8,11},{1,5,8,11},{1,9,8,11},{1,5,7,11},{1,8,7,11},{1,5,8,7,11},{1,5,7,6,11},{1,9,11},{1,2,9,11},{1,8,9,11},{5,1,9,11},{5,8,9,11},{5,1,8,9,11},{4,5,8,9,11}};
	int[] B=b[k];
	Chain c=Chain.setChain(B);
        return c;
    }

    

    public static Chain getChainUnfocused(int i,int j) {
	if(j%7==0) return null;
	if(onFocusedList(i,j)==true) return null;
	return getChain(i,j);
    }
    
    
    public static  boolean onFocusedList(int i,int j) {
	int[][] t=focusedList();
	for(int k=0;k<16;++k) {
	    if((i==t[k][0])&&(j==t[k][1])) return true;
	}
	 return false;
    }

    public static int[][] focusedList() {
	int[][] t={{1,10},{2,9},{2,11},{2,2},{2,13},{1,11},{0,3},{4,3},{4,4},{0,6},{4,8},{0,1},{0,10},{1,13},{3,4},{4,6}};
	return t;
    }

    /**END CHAIN GETTING*/
    

    /**********MAIN TRIANGLE PRODUCT TESTS***********/

    public static boolean main0(TriangleProduct T) {
	if(offDiagonal(T)==true) return true;
	double d1=distPreferredUpper(T);
	boolean test=unfocusedTest(T,d1);
	if(test==true) return true;
	return false;
    }

    public static boolean main1(TriangleProduct T) {
	if(offDiagonal(T)==true) return true;
	double d1=distPreferredUpper(T);
	boolean test=focusedTest(T,d1);
	if(test==true) return true;
	return false;
    }

    /**END MAIN TESTS*/
    
    public static boolean offDiagonal(TriangleProduct T) {
	Complex[] z=T.controlPoint();
	double[] r=T.radius();
	double d=Complex.dist(z[0],z[1])-r[0]-r[1];
	if(d>1.0/16) return true;
	return false;
    }


    /**This is the only upper bound on distance we use.  Since we are
       only considering the preferred chains, and we are taking mins,
       this gives a lower bound for the distances amongst all chains*/
    
    public static double distPreferredUpper(TriangleProduct T) {
	double min=100;
        double d=0;
	boolean test=false;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<=7;j=j+7) {
	       Chain c=getChain(i,j);
	       d=distUpper(T,c);
	       if(d<min) min=d;
	    }
	}
	return min;
    }



    /**These are the lower bounds on distance.  Since we are
interested in lower bounds, and since we are minimizing, we do
not need to worry about whether a given chain is relevant.
Including possibly irrelevant chains only can decrease the min.

The way each test works is that we compute until we either 
beat our standard (d1), in which case the test fails, or we
go all the way to the end, in which case the test passes.
Our standard (d1) is the upper bound coming from the preferred chains.*/

    public static boolean irrelevantTest(TriangleProduct T0,double d1) {
	TriangleProduct T=T0.makeAnti();
        double d=0;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<14;++j) {
		Chain c=getChain(i,j);
		d=distLower(T,c);
	        if(d<d1) return false;
	    }
	}
	return true;
    }

    public static boolean unfocusedTest(TriangleProduct T,double d1) {
        double d=0;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<14;++j) {
		Chain c=getChainUnfocused(i,j);
		if(c!=null) {
		    d=distLower(T,c);
		    if(d<d1) return false;
		}
	    }
	}
	return true;
    }

    public static boolean focusedTest(TriangleProduct T,double d1) {
        double d=0;
	for(int k=0;k<16;++k) {
	    Chain c=getChainFocused(k);
	    d=distLower(T,c);
	    if(d<d1) return false;
	}
	return true;
    }




    

    /**Distances for individual chains*/
    
    public static double distUpper(TriangleProduct T,Chain c) {
	boolean test=isRelevant(T,c);
	if(test==false) return 100;
	Complex[] z=T.controlPoint();
	double d=c.dist(z);
	double[] r=T.radius();
	return d+r[0]+r[1];
    }

    public static double distLower(TriangleProduct T,Chain c) {
	Complex[] z=T.controlPoint();
	double d=c.dist(z);
	double[] r=T.radius();
	return d-r[0]-r[1];
    }

    /**This returns true if every line defined by the triangle 
       product spans the chain*/
    
    public static boolean isRelevant(TriangleProduct T,Chain c) {
	for(int a=0;a<3;++a) {
	    for(int b=0;b<3;++b) {
		Complex w=c.transplant(T.P[1].z[b]);
		Complex[] Z={T.P[0].z[a],w};
		boolean test=checkCross(Z,c);
		if(test==false) return false;
	    }
	}
	return true;
    }
    
    public static boolean checkCross(Complex[] W,Chain c) {
	for(int i=0;i<c.COUNT-1;++i) {
	    boolean test=Vector.checkCross(W[0],W[1],c.Z[i][0],c.Z[i][1]);
	    if(test==false) return false;
	}
	return true;
    }


}

