import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    Dodecahedron D;
    ControlPanel DISPLAY,DISPLAY2,COMPUTE;
    Lever GOOD,ROTATE,BAD;
    ListenSquare CONTROL,GO,STOP;
    Complex[] TRIAL=new Complex[2];
    TriangleProduct[] TRI=new TriangleProduct[40];
    TriangleProduct CURRENT;
    int COUNT=0;
    SelectInteger SUB;
    DivideAndConquer DC;
    Path2D.Double[] PATH=new Path2D.Double[10000];
    Color[] COL=new Color[10000];
    String[] MESSAGE=new String[4];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setPanels();
	 setScales(180,380,200,200);
	 
	 GOOD=new Lever(500,15,0,14);
	 ROTATE=new Lever(700,15,0,5);
	 BAD=new Lever(500,55,0,16);

	 
	 CONTROL=new ListenSquare(0,0,800,150);
	 for(int i=0;i<2;++i) TRIAL[i]=new Complex(0,0);
	 TRIAL[0]=new Complex(.9,.05);
	 TRIAL[1]=new Complex(2.9,.05);
	 SUB=new SelectInteger(200,20,40,20,4,0,40,1);
         for(int i=0;i<40;++i) TRI[i]=TriangleProduct.initial(0);
	 GO=new ListenSquare(300,20,40,20);
	 STOP=new ListenSquare(300,40,40,20);
	 DC=new DivideAndConquer();
	 MESSAGE[0]="not running";
	 MESSAGE[1]="";
	 MESSAGE[2]="";
	 MESSAGE[3]="";

     }



    
    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};


	String[] DisplayString={"faces","vertices","display"};
	int[] DisplayState={1,0,0,1,0,1};
        DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,2);
        DISPLAY2=new ControlPanel(C0,DisplayString,DisplayState,2);

	String[] ComputeString={"vs unfocused","vs focused","tests"};
       	int[] ComputeState={1,0};
        COMPUTE=new ControlPanel(C0,ComputeString,ComputeState,2);
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawPenta0(g);
      drawTriangleProduct(g);
      drawPoints(g);
      drawPaths(g);
      drawControls(g);
      drawMessage(g);
   }
    
    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,80,80));
      g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,16));
	for(int i=0;i<4;++i) {
	    g.drawString(MESSAGE[i],200,80+20*i);
	}
    }

    

    public void drawPaths(Graphics2D g) {
	for(int i=0;i<COUNT;++i) {
	    Path2D.Double p=transform(PATH[i]);
	    g.setColor(COL[i]);
	    g.fill(p);
	    g.setColor(Color.black);
	    g.draw(p);
	}
    }
    
    public void drawTriangleProduct(Graphics2D g) {
	for(int i=0;i<SUB.val+1;++i) {
	    TRI[i].render(this,g,Color.white,Color.white);
	}
	TriangleProduct T=TRI[SUB.val];
	T.render(this,g,Color.yellow,Color.pink);
	CURRENT=new TriangleProduct(T);
    }
    
    public void drawPenta0(Graphics2D g) {
	int[] b={0};
	Chain c=Chain.setChain(b);
	drawPoly(g,c.P[0]);
	PolygonWrapper Q=c.P[0].translate(2);
	drawPoly(g,Q);
	if(DISPLAY.L[1].on==1) drawPentaVertices(g,c.P[0],0);
	if(DISPLAY2.L[1].on==1) drawPentaVertices(g,Q,3);
    }

    public void drawPoints(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int[] X={0,2};
	for(int i=0;i<2;++i) {
	   p.reset();
	   p.moveTo(X[i]-1,TRIAL[i].y);
	   p.lineTo(X[i]+1,TRIAL[i].y);
	   p.moveTo(TRIAL[i].x,-1);
   	   p.lineTo(TRIAL[i].x,1);
	   p=transform(p);
	   g.setColor(new Color(0,0,255,100));
	   g.draw(p);
	}
    }
        
    public void drawPoly(Graphics2D g,PolygonWrapper P) {
	Path2D.Double p=P.toPath();
	p=transform(p);
	Color C=Color.white;
	g.setColor(C);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
    }

    
    public void drawPentaVertices(Graphics2D g,PolygonWrapper P,int k) {
	Color[] COL={Color.white,Color.black,new Color(220,0,0),Color.blue,Color.magenta};
	for(int j=0;j<5;++j) {
	    int i=(j+k)%5;
	    fillPoint(g,P.z[i],.04,Color.black,100);
	    fillPoint(g,P.z[i],.03,COL[P.z[j].tag],100);
	}
    }

    public void drawControls(Graphics2D g) {
      CONTROL.render(g,new Color(0,150,150));
      DISPLAY.render2(g,0,0,80);
      DISPLAY2.render2(g,85,0,80);
      COMPUTE.render(g,0,100,110);
      GOOD.render2(g,"chains",new Color(200,0,200));
      ROTATE.render2(g,"rotate",new Color(200,0,200));
      BAD.render2(g,"focused chains",new Color(80,0,160));
      if(DC.halt==true) GO.render(g,Color.green);
      if(DC.halt==false) STOP.render(g,Color.red);
      SUB.render(g,Color.red,Color.white,Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,16));
      Double X=new Double(TRIAL[0].x);
      Double Y=new Double(TRIAL[0].y);
      String S=X.toString()+"    "+Y.toString();
      g.setColor(Color.black);
      g.drawString(S,400,100);
    }

    public void selectChain(Point X) {
	GOOD.process(X);
	ROTATE.process(X);
	BAD.process(X);
    }

    public int getInitial() {
	Complex[] W={new Complex(TRIAL[0]),new Complex(TRIAL[1].x-2,TRIAL[1].y)};
	int ii=-1;
	for(int i=0;i<10;++i) {
	   TriangleProduct T=TriangleProduct.initial(i);
	   if(T.contains(W)==true) return i;
	}
	return -1;
    }

    
    public void setPoints() {
	recordPoint();
	Complex[] W={new Complex(TRIAL[0]),new Complex(TRIAL[1].x-2,TRIAL[1].y)};
	int ii=getInitial();
	if(ii==-1) return;

	TRI[0]=TriangleProduct.initial(ii);

	for(int i=0;i<SUB.val;++i) {
	    TriangleProduct[] T=TriangleProduct.sub(TRI[i]);
	    int test=-1;
	    if(T[0].contains(W)==true) test=0;
	    if(T[1].contains(W)==true) test=1;
            TRI[i+1]=new TriangleProduct(T[test]);
	}
    }


    public void recordPoint() {
	Complex z=new Complex(SOURCE);
	Complex[] W1=new Complex[2];
	for(int i=0;i<2;++i) W1[i]=new Complex(TRIAL[i]);
        if(z.x<1) W1[0]=new Complex(z);
	else W1[1]=new Complex(z);
	TRIAL[0]=new Complex(W1[0]);
	TRIAL[1]=new Complex(W1[1].x,W1[1].y);
    }




    


    public void doGo() {
	if(DC.halt==false) return;
	DC=new DivideAndConquer(this.M);
	new Thread(DC).start();
    }

    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	
	if(CONTROL.inside(J.X)==1) {
	   selectChain(J.X);
	   DISPLAY.toggle(J.X);
	   DISPLAY2.toggle(J.X);
	   COMPUTE.switchMode(J.X);
	   M.repaint();
	   SUB.modify(J.X);
	   setPoints();
	   M.repaint();
	   if(GO.inside(J.X)==1) doGo();
	   if(STOP.inside(J.X)==1) DC.halt=true;
	   doTest();
	   return;
	}

	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    setPoints();
	}
	if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	M.repaint();
    }
    
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) return;
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    setPoints();
	}
	M.repaint();
     }

    public void doTest() {
	for(int i=0;i<14;++i) {
	    Chain c=ChainCompete.getChain(0,i);
	    c.print();
	}
	


    }

}

