import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class DivideAndConquer implements Runnable {
    Manager M;
    boolean halt;
    int COUNT,WIN;
    double VOL,VOL0;
    TriangleProduct[] LIST=new TriangleProduct[200];
    long TIME;

    public DivideAndConquer() {
	halt=true;
    }

    public DivideAndConquer(Manager MM) {
	this.M=MM;
	halt=true;
	COUNT=1;
	WIN=0;
	VOL=0;
	int index=M.C.getInitial();
	LIST[0]=TriangleProduct.initial(index);
    }

    public void run() {
	halt=false;
	M.C.COUNT=0;
	VOL0=LIST[0].volume();
	Complex z=M.C.TRIAL[0];
	TIME=Time.time();
	
	while(halt==false) {
	  
	    TriangleProduct current=LIST[COUNT-1];
            int t=mainTest(current);

	    
	    if(t==0) subdivide();
	    if(t==1) {
		--COUNT;
		++WIN;
		VOL=VOL+current.volume();
		sendStats();
		if(current.contains(0,z)==true) send(current);
	    }
	    if(COUNT==0) halt=true;
	    if(COUNT==99) {
		halt=true;
		M.C.MESSAGE[0]="TEST FAILED";
		M.C.MESSAGE[1]="";
		M.C.MESSAGE[2]="";
	    }
	}
	System.out.println("done");
	M.repaint();
    }

    public int mainTest(TriangleProduct T) {

	int mode=M.C.COMPUTE.mode;
	    
	if(mode==1) {
	   int[] b={0,1,1,1,1};
	   if(match(T,b)==true) return 1;
	 }

	 boolean test=false;
	 if(mode==0) test=ChainCompete.main0(T);
	 if(mode==1) test=ChainCompete.main1(T);
	 if(test==true) return 1;
	 return 0;
    }
    

    /**This is for eliminating the center (0) or the corner (1)*/
    
    public static boolean match(TriangleProduct T,int[] b) {
	boolean omit=true;
	for(int i=1;i<b.length;++i) {
	    if(T.SUB[i]!=b[i]) omit=false;
	}
	return omit;
    }

    


    public void subdivide() {
	TriangleProduct current=LIST[COUNT-1];
	LIST[COUNT-1]=TriangleProduct.sub(0,current);
	LIST[COUNT-0]=TriangleProduct.sub(1,current);
	COUNT=COUNT+1;
    }

    public void send(TriangleProduct current) {
	PolygonWrapper Q=current.P[1].translate(2);
        Path2D.Double p=Q.toPath();
	M.C.PATH[M.C.COUNT]=p;
	M.C.COL[M.C.COUNT]=new Color(100,200,255);
	++M.C.COUNT;
    }

    public void sendStats() {
	Integer I=new Integer(COUNT);
	M.C.MESSAGE[0]="list length "+I.toString();
	I=new Integer(WIN);
	M.C.MESSAGE[1]="partition size "+I.toString();
	Double D=new Double(VOL/VOL0);
	M.C.MESSAGE[2]="volume "+D.toString();
	long t=Time.time()-TIME;
	M.C.MESSAGE[3]=Time.toString("time ",t);
	M.repaint();
    }


}
