import java.awt.event.*;
import java.awt.*;


public class RelevanceTest {

    /**This routine returns false if it can show that
       no line defined by the triangle product spans the chain.*/

    public static boolean weak(TriangleProduct T,Chain c) {
	for(int k=0;k<c.COUNT-1;++k) {
	    boolean test=intersectionTest(T,c,k);
	    if(test==false) return false;
	}
	return true;
    }

    public static boolean intersectionTest(TriangleProduct T,Chain c,int k) {
	boolean pos=false;
	boolean neg=false;
	for(int a=0;a<3;++a) {
	    for(int b=0;b<3;++b) {
		Complex[] Z={T.P[0].z[a],c.transplant(T.P[1].z[b])};
		int test=intersectionSign(c,Z,k);
		if(test==-1) neg=true;
		if(test==+1) pos=true;
		if(test==0) return true;
	    }
	}
	if((pos==true)&&(neg==false)) return false;
	if((neg==true)&&(pos==false)) return false;
        return true;
    }


    public static int intersectionSign(Chain c,Complex[] Z,int k) {
	Complex[] W={c.Z[k][0],c.Z[k][1]};
	int a0=Complex.orientationWeak(Z[0],Z[1],W[0]);
	int a1=Complex.orientationWeak(Z[0],Z[1],W[1]);
	if(a0+a1<0) return -1;
	if(a0+a1>0) return 1;
	return 0;
    }


}


