import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    int TYPE;
    Manager M;
    Path2D.Double TRI;
    Color COLOR;
    Dodecahedron D;
    PolygonWrapper[] P=new PolygonWrapper[10];
    int COUNT=0;
    int CHOICE;
    double[] T=new double[2];

     public PictureCanvas(int type) {
	 TYPE=type;
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(250,250,30,30);
	 D=new Dodecahedron();
	 CHOICE=0;
	 T[0]=.5;
	 T[1]=.5;

     }
    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      Chain c=ChainCompete.getChain(M.C.ROTATE.val,M.C.GOOD.val);
      Chain c2=ChainCompete.getChainFocused(M.C.BAD.val);
      if(getDisplay(0,0)==1) drawPenta(g,c);
      if(getDisplay(0,1)==1) drawVertices(g,c);
      if(getDisplay(1,0)==1) drawPenta(g,c2);
      if(getDisplay(1,1)==1) drawVertices(g,c2);
   }

    
    public int getDisplay(int choice,int k) {
	if(choice==0) return M.C.DISPLAY.L[k].on;
	else return M.C.DISPLAY2.L[k].on;
    }

    

    public int getChoice() {
	int r=0;
	try {
	  if(TYPE==0) r=M.C.GOOD.val;
	}
	catch(Exception e) {}
	return r;
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight()); 
	double t=A[1].getScaleX();
	Integer T=new Integer(getScale());
	g.setColor(Color.black);
         g.setFont(new Font("Helvetica",Font.PLAIN,15));
	 g.drawString(T.toString(),5,20);
    }

    public int getScale() {
	double t=A[1].getScaleX();
	t=t/30;
	t=t*t*t*t;
	t=Math.log(t)/Math.log(2);
	if(t>-.00001) return (int)(t+.01);
	t=-t;
	int k=(int)(t+.01);
	return -k;
    }



    public void drawPenta(Graphics2D g,Chain c) {
	for(int i=0;i<c.COUNT;++i) {
	    drawPoly(g,c.P[i],true);
	}
    }

    public void drawEdges(Graphics2D g,Chain c) {

	for(int i=0;i<c.COUNT-1;++i) {
	    if(c.Z[i]!=null) {
              PolygonWrapper P=new PolygonWrapper(2,c.Z[i]);
              Path2D.Double p=P.toPath();
	      p=transform(p);
	      g.setStroke(new BasicStroke(3));
	      g.setColor(Color.blue);
	      g.draw(p);
	    }
	    else {
		System.out.println("null "+i);
	    }
	}
	g.setStroke(new BasicStroke(1));
    }

    public void drawVertices(Graphics2D g,Chain c) {
	for(int i=0;i<c.COUNT;++i) {
	    drawVertices0(g,c.P[i]);
	}
    }



        
    public void drawPoly(Graphics2D g,PolygonWrapper P,boolean label) {
	Path2D.Double p=P.toPath();
	p=transform(p);
	Color C=D.faceColor(P.name);
	g.setColor(C);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
	if(label==false) return;
	int n=P.name;
	drawLabel(g,n,P.center());
    }

    
    public void drawVertices0(Graphics2D g,PolygonWrapper P) {
	Color[] COL={Color.white,Color.black,new Color(220,0,0),Color.blue,Color.magenta};
	for(int i=0;i<5;++i) {
	    fillPoint(g,P.z[i],.15,Color.black,100);
	    fillPoint(g,P.z[i],.13,COL[P.z[i].tag],100);
	}
    }


    public static Complex fromPath(Path2D.Double X) {
	AffineTransform A=AffineTransform.getTranslateInstance(0,0);
	PathIterator P=X.getPathIterator(A);
	double[] coords=new double[6];
	int count=0;
	Complex CURRENT=new Complex();
	P.currentSegment(coords);
	CURRENT=new Complex(coords[0],coords[1]);
	return(CURRENT);
    }


    public void drawLabel(Graphics g,int n,Complex z) {
       Integer I=new Integer(n);
       g.setColor(Color.black);
       double t=A[1].getScaleX();
       int f=(int)(t*.7);
       g.setFont(new Font("Helvetica",Font.PLAIN,f));
       Path2D.Double p=new Path2D.Double();
       p.moveTo(z.x,z.y);
       p=transform(p);
       Complex w=fromPath(p);
       g.drawString(I.toString(),(int)(w.x-f/3),(int)(w.y+f/3));
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	repaint();
    }



    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }

    


}

