import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class is the product of two right triangles.
   In each case the right-angled vertex is listed last*/

public class TriangleProduct {
    PolygonWrapper[] P=new PolygonWrapper[2];
    int parity;
    int COUNT;
    int[] SUB=new int[100];

    
    public TriangleProduct() {
	P[0]=new PolygonWrapper();
	P[1]=new PolygonWrapper();
	for(int i=0;i<100;++i) SUB[i]=-1;
	COUNT=0;
    }


    public TriangleProduct(TriangleProduct T) {
	P[0]=new PolygonWrapper(T.P[0]);
	P[1]=new PolygonWrapper(T.P[1]);
	parity=T.parity;
	COUNT=T.COUNT;
	for(int i=0;i<COUNT;++i) SUB[i]=T.SUB[i];
    }



    public static TriangleProduct initial(int k) {
	TriangleProduct T=new TriangleProduct();
	if(k%2==0) T=initial0();
	else T=initial1();
        int k2=k/2;
	Complex u=Chain.rootOfUnity5(k2);
	for(int i=0;i<3;++i) T.P[1].z[i]=Complex.times(T.P[1].z[i],u);
	T.parity=0;
	T.COUNT=1;
	T.SUB[0]=k;
	return T;
    }


    public static TriangleProduct initial1() {
	TriangleProduct T=initial0();
	Complex u=Chain.rootOfUnity5(1);
	for(int i=0;i<3;++i) {
	    T.P[1].z[i]=T.P[1].z[i].conjugate();
	    T.P[1].z[i]=Complex.times(T.P[1].z[i],u);
	}
	return T;
    }

    


    public static TriangleProduct initial0() {
	Complex[] Z=new Complex[3];
	Z[0]=new Complex(0,0);
	Z[1]=new Complex(1,0);
	Z[2]=Complex.plus(Z[1],Chain.rootOfUnity5(1));
	Z[2]=Z[2].scale(.5);
	TriangleProduct T=new TriangleProduct();
	T.P[0]=new PolygonWrapper(3,Z);
	T.P[1]=new PolygonWrapper(3,Z);
	return T;
    }


    /**drawing*/
    public void render(ControlCanvas C,Graphics2D g,Color COL1,Color COL2) {
	Path2D.Double p=this.P[0].toPath();
	p=C.transform(p);
	g.setColor(COL1);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
	PolygonWrapper Q=this.P[1].translate(2);
	p=Q.toPath();
	p=C.transform(p);
	g.setColor(COL2);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
    }

    /**subdivision*/

    public static TriangleProduct sub(int k,TriangleProduct T) {
	TriangleProduct[] U=sub(T);
	return U[k];
    }

    public static TriangleProduct[] sub(TriangleProduct T) {
	if(T.parity==0) return sub0(T);
	return sub1(T);
    }

    public static TriangleProduct[] sub0(TriangleProduct T) {
	PolygonWrapper[] SUB=sub(T.P[0]);
	TriangleProduct[] ST=new TriangleProduct[2];
        for(int i=0;i<2;++i) {
	    ST[i]=new TriangleProduct();
            ST[i].P[0]=new PolygonWrapper(SUB[i]);
	    ST[i].P[1]=new PolygonWrapper(T.P[1]);
	    ST[i].parity=1;
	    for(int ii=0;ii<T.COUNT;++ii) ST[i].SUB[ii]=T.SUB[ii];
	    ST[i].SUB[T.COUNT]=i;
	    ST[i].COUNT=T.COUNT+1;
	}
	return ST;
    }



    public static TriangleProduct[] sub1(TriangleProduct T) {
	PolygonWrapper[] SUB=sub(T.P[1]);
	TriangleProduct[] ST=new TriangleProduct[2];
        for(int i=0;i<2;++i) {
	    ST[i]=new TriangleProduct();
	    ST[i].P[0]=new PolygonWrapper(T.P[0]);
            ST[i].P[1]=new PolygonWrapper(SUB[i]);
	    ST[i].parity=0;
            for(int ii=0;ii<T.COUNT;++ii) ST[i].SUB[ii]=T.SUB[ii];
	    ST[i].SUB[T.COUNT]=i;
	    ST[i].COUNT=T.COUNT+1;
	}
	return ST;
    }


    /**This works when the right angled point is listed last*/

    public static PolygonWrapper sub(int j,PolygonWrapper P) {
	PolygonWrapper[] Q=sub(P);
	return Q[j];
    }
    

    public static PolygonWrapper[] sub(PolygonWrapper P) {
	Complex dir=Complex.minus(P.z[0],P.z[1]);
	dir=Complex.times(dir,new Complex(0,1));
	Complex w=Complex.plus(P.z[2],dir);
	Complex u=Vector.findCross2(P.z[0],P.z[1],P.z[2],w);
        Complex[] Z0=new Complex[3];
	Complex[] Z1=new Complex[3];
	Z0[0]=new Complex(P.z[0]);
	Z0[1]=new Complex(P.z[2]);
	Z0[2]=new Complex(u);
	Z1[0]=new Complex(P.z[2]);
	Z1[1]=new Complex(P.z[1]);
	Z1[2]=new Complex(u);
	PolygonWrapper P0=new PolygonWrapper(3,Z0);
	PolygonWrapper P1=new PolygonWrapper(3,Z1);
	PolygonWrapper[] SP={P0,P1};
	return SP;
    }

    /**end subdivision*/

    

    /**contains point*/

    public boolean contains(Complex[] z) {
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<2;++i) {
	    p=this.P[i].toPath();
	    boolean test=p.contains(z[i].x,z[i].y);
	    if(test==false) return false;
	}
	return true;
    }

    public boolean contains(int i,Complex z) {
	Path2D.Double p=new Path2D.Double();
	p=this.P[i].toPath();
	boolean test=p.contains(z.x,z.y);
	return test;
    }



    /**Makes the antipodal chain: Just repeats the first factor*/

    public TriangleProduct makeAnti() {
	TriangleProduct T=new TriangleProduct(this);
	T.P[1]=new PolygonWrapper(this.P[0]);
	return T;
    }
    

    /**end subdivision routines*/


    /**geometric measurements*/

    public double volume() {
	return area(P[0])*area(P[1]);
    }
	
    public static double area(PolygonWrapper P) {
	double a=Complex.dist(P.z[0],P.z[2]);
	double b=Complex.dist(P.z[1],P.z[2]);
	return a*b;
    }

    public static Complex controlPoint(PolygonWrapper P) {
	Complex u=Complex.plus(P.z[0],P.z[1]);
	u=u.scale(.5);
	return u;
    }

    public static double radius(PolygonWrapper P) {
	Complex u=controlPoint(P);
	return Complex.dist(u,P.z[2]);
    }

    public Complex[] controlPoint() {
	Complex[] z={controlPoint(P[0]),controlPoint(P[1])};
	return z;
    }

    public double[] radius() {
	double[] r={radius(P[0]),radius(P[1])};
	return r;
    }

    /***end geometric routines***/


    /***getting a random point*/

    public Complex[] random() {
	Complex[] z=new Complex[2];
	for(int i=0;i<2;++i) z[i]=random(P[i]);
	return z;
    }

    public Complex random(PolygonWrapper P) {
	double[] r=new double[3];
	double s=0;
	for(int i=0;i<3;++i) {
            r[i]=Math.random();
	    s=s+r[i];
	}
	for(int i=0;i<3;++i) r[i]=r[i]/s;
	Complex w=new Complex(0,0);
	for(int i=0;i<3;++i) {
	    w=Complex.plus(w,P.z[i].scale(r[i]));
	}
	return w;
    }




    public void print() {
	System.out.println("parity "+parity);
	P[0].print();
	P[1].print();
    }
    public void printSeq() {
	for(int i=0;i<COUNT;++i) System.out.print(SUB[i]+" ");
	System.out.println("");
    }

}


