import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.math.*;

public class Chain {
    PolygonWrapper[] P=new PolygonWrapper[10];
    Complex[][] Z=new Complex[10][2];
    int[] B;
    int COUNT;

    public Chain() {}

    public static Chain setChain(int[] a) {
	Dodecahedron D=new Dodecahedron();
	Chain C=new Chain();
	C.P[0]=D.bottom();
	
	for(int i=0;i<a.length;++i) { 
            int m=D.BOTTOM;
	    D.roll(a[i]);  
            int n=D.BOTTOM;
	    C.P[i+1]=D.bottom();
	    C.Z[i]=D.edge(m,n);

	}
	C.COUNT=a.length+1;
	C.B=new int[a.length];
	for(int i=0;i<a.length;++i) C.B[i]=a[i];
	return C;
    }


    /**transplanting complex numbers.  Note  the multiplication
       by the 5th root of unity w^2, which comes from the way that our
       coloring interacts with the antipodal map*/


    public Complex transplant(Complex z0) {
	Complex z=Complex.times(z0,rootOfUnity5(2)); 
	int L=COUNT-1;
	Complex c=P[L].center();
        Complex w=new Complex(1,0);
	for(int i=0;i<5;++i) {
	    if(P[L].z[i].tag==0) w=P[L].z[i];
	}
	w=Complex.minus(w,c);
	Complex w1=Complex.times(w,z.conjugate());
	Complex w2=Complex.plus(w1,c);
	return w2;
    }



    public PolygonWrapper transplant(PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper();
	for(int i=0;i<P.count;++i) Q.z[i]=transplant(P.z[i]);
	Q.name=P.name;
	Q.count=P.count;
	return Q;
    }

    public double dist(Complex[] z) {
	Complex w1=transplant(z[1]);
	Complex[] w={z[0],w1};
	boolean test=checkCross(w);
	if(test==false) return 100;
	return Complex.dist(w[0],w[1]);
    }


    public static Complex rootOfUnity5(int k) {
	double a=2*k*Math.PI/5;
	double c=Math.cos(a);
	double s=Math.sin(a);
	return new Complex(c,s);
    }
    
    public static Complex rootOfUnity10(int k) {
	double a=2*k*Math.PI/10;
	double c=Math.cos(a);
	double s=Math.sin(a);
	return new Complex(c,s);
    }
    

    /**crossing tests*/

    public Complex[] getSegment(double[] T) {
	int L=COUNT-2;
	Complex z1=Complex.plus(Z[0][0].scale(1-T[0]),Z[0][1].scale(T[0]));
	Complex z2=Complex.plus(Z[L][0].scale(1-T[1]),Z[L][1].scale(T[1]));
	Complex[] zz={z1,z2};
	return zz;
    }

    public boolean checkCross(double[] T) {
	return checkCross(getSegment(T));
    }

    
    public boolean checkCross(Complex[] W) {
	for(int i=0;i<COUNT-1;++i) {
	    boolean test=Vector.checkCross(W[0],W[1],Z[i][0],Z[i][1]);
	    if(test==false) return false;
	}
	return true;
    }

    public double randomPinched() {
	double t=.001+.998*Math.random();
	return t;
    }

    public void print() {
	System.out.print("{");
	for(int i=0;i<COUNT-1;++i) {
	    if(i<COUNT-2) System.out.print(B[i]+",");
	    if(i==COUNT-2) System.out.print(B[i]+"}");
	}
	System.out.print(",");
    }





    
}


