import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    Dodecahedron D;
    ControlPanel DISPLAY,DISPLAY2,COMPUTE;
    ControlPanel SPECIAL;
    Lever BAD,GOOD;
    ListenSquare CONTROL,GO,STOP,TEST;
    TriangleProduct[] TRI=new TriangleProduct[40];
    TriangleProduct CURRENT;
    int COUNT=0;
    Complex[] PLOT=new Complex[10000];
    String[] MESSAGE=new String[2];
    

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setPanels();
	 setScales(10,400,400,400);

	 
	 BAD=new Lever(200,25,0,12);
	 GOOD=new Lever(200,95,0,6);
	 
	 CONTROL=new ListenSquare(0,0,800,150);
	 SOURCE=new Complex(.9,.05);
	 TEST=new ListenSquare(340,110,40,20);
	 MESSAGE[0]="x";
	 MESSAGE[1]="x";
     }

    
    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};


	String[] DisplayString={"faces","vertices","display"};
	int[] DisplayState={1,0};
        DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,2);
        DISPLAY2=new ControlPanel(C0,DisplayString,DisplayState,2);
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawPenta0(g);
      drawDomain(g);
      drawPoints(g);
      drawPlot(g);
      drawControls(g);
      drawMessage(g);
   }
    
    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,80,80));
      g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawMessage(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.setColor(Color.white);
	g.drawString(MESSAGE[0],200,60);
	g.drawString(MESSAGE[1],200,130);
    }

    public void drawPlot(Graphics2D g) {
	for(int i=0;i<COUNT;++i) {
	    fillPoint(g,PLOT[i],.002,Color.black,8);
	}
    }
    
    public void drawDomain(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int[] zone={0,2};
	for(int i=0;i<2;++i) {
	   Complex[] Z0=DecagonCombinatorics.zone(zone[i]);
	   for(int j=0;j<4;++j) Z0[j]=Z0[j].conjugate();
           PolygonWrapper P=new PolygonWrapper(4,Z0);
	   p=P.toPath();
	   p=transform(p);
	   g.setColor(Color.pink);
	   g.fill(p);
	   g.setColor(Color.black);
	   g.draw(p);
	}

	p.reset();
	Complex[] Z=DecagonCombinatorics.cityDividerUpper();
	p.moveTo(Z[0].x,Z[0].y);
	p.lineTo(Z[1].x,Z[1].y);
	Z=DecagonCombinatorics.cityDividerLower();
	p.moveTo(Z[0].x,Z[0].y);
	p.lineTo(Z[1].x,Z[1].y);
	p=transform(p);
	g.setColor(Color.black);
	g.draw(p);
	
    }

    public void drawPenta0(Graphics2D g) {
	int[] b={0};
	Chain c=Chain.setChain(b);
	drawPoly(g,c.P[0]);
    }

    public void drawPoints(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	   p.reset();
	   p.moveTo(-1,SOURCE.y);
	   p.lineTo(+1,SOURCE.y);
	   p.moveTo(SOURCE.x,-1);
   	   p.lineTo(SOURCE.x,1);
	   p=transform(p);
	   g.setColor(new Color(0,0,255,100));
	   g.draw(p);
	   Complex w=Farpoint.getFarpoint(SOURCE);
	fillPoint(g,w,.002,Color.blue,16);
    }
        
    public void drawPoly(Graphics2D g,PolygonWrapper P) {
	Path2D.Double p=P.toPath();
	p=transform(p);
	Color C=Color.white;
	g.setColor(C);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
    }
    
    public void drawControls(Graphics2D g) {
      CONTROL.render(g,new Color(0,150,150));
      DISPLAY.render2(g,0,0,80);
      DISPLAY2.render2(g,85,0,80);
      BAD.render2(g,"bad chains",new Color(80,0,160));
      GOOD.render2(g,"good chains",new Color(80,0,160));
      TEST.render(g,Color.blue);
    }

    public void selectChain(Point X) {
	BAD.process(X);
	GOOD.process(X);
	
	int[] t=ChainCompete.transplantCodeGood(GOOD.val);
	MESSAGE[1]="";
	for(int i=0;i<t.length;++i) {
	    Integer T=new Integer(t[i]);
	    MESSAGE[1]=MESSAGE[1]+T.toString()+"  ";
	}

	t=ChainCompete.transplantCodeBad(BAD.val);
	MESSAGE[0]="";
	for(int i=0;i<t.length;++i) {
	    Integer T=new Integer(t[i]);
	    MESSAGE[0]=MESSAGE[0]+T.toString()+"  ";
	}


	
    }


    public void doGo() {}
    
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	
	if(CONTROL.inside(J.X)==1) {
	   selectChain(J.X);
	   DISPLAY.toggle(J.X);
	   DISPLAY2.toggle(J.X);
	   M.repaint();
	   return;
	}

	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	M.repaint();
    }



    /**gets the transplant code*/
    public void doTest2X() {

	System.out.println("");
	int[][] tt={{2,10,11},{1,9,11},{1,8,11},{5,7,11},{4,6,11},{3,6,11}};
	
	for(int k=0;k<12;++k) {
	    int[] I=tt[k];
	    Chain C=Chain.setChain(I);
	    Complex z0=C.transplant(new Complex(0,0));
	    Complex z1=C.transplant(new Complex(1,0));
	    int[] J=NumberRecognizer.recognize(z0);

	    int min=100;
	    for(int i=0;i<5;++i) {
		if(min>=J[i]) min=J[i];
	    }
	    for(int i=0;i<5;++i) J[i]=J[i]-min;

	    
	    Complex z2=Complex.minus(z1,z0);
	    int q=NumberRecognizer.recognizeShort(z2);
	    int[] J2={J[0],J[1],J[2],J[3],J[4],q};
	    
	    ListHelp.print2(J2);
	}

    }


    
    /*

    public void doTest() {
	COUNT=0;
	System.out.println("start");
	boolean test=true;
	for(int i=0;i<100000;++i) {
	    if(i%1000==0) System.out.println("try "+i);
	    test=doTest(0);
	    if(test==false) System.out.println("oops0");
	    test=doTest(1);
	    if(test==false) System.out.println("oops1");
	}
	System.out.println("done");
    }


    public boolean doTest(int k) {
	int choice=(int)(16*Math.random());
	Complex w=new Complex();
	if(k==0) w=Farpoint.random834();
	if(k==1) w=Farpoint.random836();
	Chain[] c=new Chain[4];
	for(int i=0;i<3;++i) c[i]=ChainCompete.getChainGood(i);
	if(k==1) c[2]=ChainCompete.getChainGood(3);
	c[3]=ChainCompete.getChainBad(choice);
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=c[i].transplant(w);
	double d=imCr(z);
	if(d<0) {
	    System.out.println("fail "+k+" "+choice);
	    w.print();
            return false;
	}
	return true;
    }
    */


    public static double imCr(Complex[] z) {
	Complex w02=Complex.minus(z[0],z[2]);
	Complex w13=Complex.minus(z[1],z[3]);
	Complex w01=Complex.minus(z[0],z[1]);
	Complex w23=Complex.minus(z[2],z[3]);
	Complex w0213=Complex.times(w02,w13);
	Complex w0123=Complex.times(w01,w23);
	Complex w=Complex.divide(w0213,w0123);
	return w.y;
    }

    
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) return;
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
     }

    
    

}

