import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Decagon {

    /**here is the main routine.  There are 10 vertices: k=0,...,9*/
    
    public static Complex vertex(int k,Complex s) {
	Complex z=rootOfUnity5(4.5-k);
	Complex z2=Complex.times(z,s.conjugate());
	Complex v=Complex.plus(base(k),z2);
	return v;
    }

    /**this gives the vertices of the decagon for the origin point*/
    
    public static Complex base(int k) {
	if(k%2==0) return baseEven(k);
	return baseOdd(k);
    }
    

    public static Complex baseEven(int k) {
	Complex z=rootOfUnity5(.5*(4-k));
	Complex w=baseA();
	w=Complex.times(z,w);
	return w;
    }

    public static Complex baseOdd(int k) {
	Complex z=rootOfUnity5(.5*(5-k));
	Complex w=baseB();
	w=Complex.times(z,w);
	return w;
    }


    //point 4
    public static Complex baseA() {
	double a=Math.PI/5;
	double v1=(1+Math.sqrt(5))/2;
	Complex z1=new Complex(v1,0);
	Complex z2=rootOfUnity5(1);
	z2.x=z2.x+1;

	
	Complex z3=Complex.plus(z1,z2);
	z3=Complex.plus(z3,z2);
	return z3;
    }
    
    //point 5
    public static Complex baseB() {
	Complex z=baseA();
	return z.conjugate();
    }

    public static Complex rootOfUnity5(double r) {
	double a=2*Math.PI/5;
	Complex z=new Complex(Math.cos(r*a),Math.sin(r*a));
	return z;
    }

    public static Complex[] rootsOfUnity5() {
	Complex[] w=new Complex[5];
	for(int i=0;i<5;++i) w[i]=rootOfUnity5(i);
	return w;
    }
}



