import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class DecagonCombinatorics {

    public static int[] hex(int k) {
	int k1=k%3;
	int k2=(k-k1)/3;
	int[] p=hex0(k1);
	for(int i=0;i<6;++i) {
	   p[i]=(p[i]+8*k2)%10;
	}
	return p;
    }
    
    public static int[] hex0(int k) {
	int[] T= {0,1,3,5,6,8};
	return T;
    }


    public static int[][] candidateTriples(int k) {
	int k1=k%3;
	int k2=(k-k1)/3;
	int[][] A=new int[4][3];
	if(k1==0) A=candidateTriples0();
	if(k1==1) A=candidateTriples1();
	if(k1==2) A=candidateTriples2();

	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		A[i][j]=(A[i][j]+8*k2)%10;
	    }
	}
	return A;
    }


    
    public static int[][] candidateTriples1() {
	int[][] a={{0,5,6},{0,5,8},{0,5,3},{0,5,1}};
		return a;
    }

    public static int[][] candidateTriples0() {
	int[][] a={{3,8,5},{3,8,0},{3,8,1},{3,8,6}};
	return a;
    }

    public static int[][] candidateTriples2() {
	int[][] a={{1,6,0},{1,6,5},{1,6,3},{1,6,8}};
	return a;
    }


    /**measures distance from triple point to the corresponding decagon vertices*/
    
    public static double commonDistance(int[] A,Complex s) {
	Complex z=triplePoint(A,s);
	Complex w=Decagon.vertex(A[0],s);
	double d0=Complex.dist(w,z);
	return d0;
    }

    /**measures the minimim distance to a decagon vertex*/
    
    public static double minDistance(int[] A,Complex s) {
	Complex z=triplePoint(A,s);
	double min=100;
	for(int i=0;i<10;++i) {
	   Complex w=Decagon.vertex(i,s);
	   double d=Complex.dist(w,z);
	   if(min>d) min=d;
	}
	return min;
    }

    /**tests if this is really a Voronoi cell vertex*/

    public static boolean isCellVertex(int[] A,Complex s) {
	double d1=commonDistance(A,s);
	double d2=minDistance(A,s);
	if(d1<d2+.000000000001) return true;
	return false;
    }

    public static int farthestTriple(int[][] A,Complex s) {
	int index=-1;
	double d=0;
	for(int i=0;i<A.length;++i) {
	    boolean cell=isCellVertex(A[i],s);
	    double test=commonDistance(A[i],s);
	    if((cell==true)&&(d<test)) {
		d=test;
		index=i;
	    }
	}
	return index;
    }

    

    

    public static Complex triplePoint(int[] A,Complex s) {
	return triplePoint(A[0],A[1],A[2],s);
    }
    
    public static Complex triplePoint(int a,int b,int c,Complex s) {
	Complex z0=Decagon.vertex(a,s);
	Complex z1=Decagon.vertex(b,s);
	Complex z2=Decagon.vertex(c,s);
	Complex[] W0=bisector(z0,z1);
	Complex[] W1=bisector(z1,z2);
	Complex z=Vector.findCross2(W0[0],W0[1],W1[0],W1[1]);
	return z;
    }


    public static Complex[] bisector(Complex z0,Complex z1) {
	 Complex z2=Complex.plus(z0,z1);
	 z2=z2.scale(.5);
	 Complex z3=Complex.minus(z0,z1);
	 z3=Complex.times(z3,new Complex(0,1));
	 Complex[] W=new Complex[2];
	 W[0]=z2;
	 W[1]=Complex.plus(z2,z3);
	 return W;
    }


    public static PolygonWrapper containingState(Complex z) {
	int t=stateNumber(z);
	if(t==-1) return null;
	Complex[] W=zone(t);
	PolygonWrapper Q=new PolygonWrapper(4,W);
	return Q;
    }

    public static int stateNumber(Complex z) {
	for(int i=0;i<15;++i) {
	    Complex[] Z=zone(i);
	    PolygonWrapper P=new PolygonWrapper(4,Z);
	    Path2D.Double p=P.toPath();
	    if(p.contains(z.x,z.y)==true) return i;
	}
	return -1;
    }


    public static Complex[] zone(int k) {
	int k1=k%3;
	int k2=(k-k1)/3;
	Complex[] Z=zone1(k1);
	Complex z=Decagon.rootOfUnity5(k2);
	for(int i=0;i<4;++i) Z[i]=Complex.times(Z[i],z);
	return Z;
    }

    public static Complex[] zone1(int k) {
	if(k==0) return zone0();
	if(k==1) return zone1();
	if(k==2) return zone2();
	return null;
    }



    
    public static Complex[] zone0() {
	Complex[] Z=zonePoints();
	Complex[] W={Z[0],Z[1],Z[3],Z[2]};
	return W;
    }
    

    public static Complex[] zone2() {
	Complex[] Z=zonePoints();
	Complex[] W={Z[2],Z[4],Z[5],Z[3]};
	return W;
    }
    
    public static Complex[] zone1() {
	Complex[] Z=zonePoints();
	Complex[] W={Z[1],Z[6],Z[5],Z[3]};
	return W;
    }



    public static Complex[] zonePoints() {
	Complex[] Z=new Complex[7];
	Z[0]=new Complex(0,0);
	Complex u1=Decagon.rootOfUnity5(1);
	Complex u2=Decagon.rootOfUnity5(4);
	
	double phi=(1+Math.sqrt(5))/2;

	Z[1]=u2.scale(.5/phi);
	Z[2]=Complex.times(Z[1],u1);
	Z[3]=Complex.plus(u2,new Complex(1,0));
	Z[3]=Z[3].scale(1/(phi*phi*phi));

	Z[4]=new Complex(1,0);
	Z[5]=Complex.plus(Z[4],u2);
        Z[5]=Z[5].scale(.5);
	Z[6]=u2;
	return Z;
    }

    public static Complex zonePoint(int k) {
	Complex[] Z=zonePoints();
	return Z[k];
    }


    /**These are the city dividers.  They give straight
       lines which separate the cities in State 1.*/

    public static Complex[] cityDividerUpper() {
	double phi=(1+Math.sqrt(5))/2;
	Complex z1=zonePoint(3);
	Complex z2=new Complex(1,0);
	Complex z3=zonePoint(5);
	Complex z4=z3.scale(1/phi);
	z4=z4.conjugate();
	Complex[] Z={z2,z4};
	return Z;
    }


    public static Complex[] cityDividerLower() {
	Complex z2=new Complex(1,0);
	Complex z3=zonePoint(3);
	z3=z3.conjugate();
	Complex[] Z={z2,z3};
	return Z;
    }



}
