import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of 3x3 matrices */


public class Matrix {
    double[][] a=new double[3][3];
    
    public Matrix(){}

    public Matrix(double[][] aa) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(int[][] aa) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(Matrix M) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		a[j][i]=M.a[i][j];
	    }
	}
    }
    

    public Matrix(Vector[] V) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }
    

    public Matrix(Vector V0,Vector V1,Vector V2) {
	Vector[] V={V0,V1,V2};
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }

    public static Matrix identity() {
	Matrix m=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		m.a[i][j]=0;
		if(i==j) m.a[i][j]=1;
	    }
	}
	return m;
    }

    

    public static Matrix times(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=0;
		for(int k=0;k<3;++k) {
		    M.a[i][j]=M.a[i][j]+M1.a[i][k]*M2.a[k][j];
		}
	    }
	}
	return(M);
    }

    public static Matrix plus(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=M1.a[i][j]+M2.a[i][j];
	    }
	}
	return(M);
    }

    public static Matrix minus(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=M1.a[i][j]-M2.a[i][j];
	    }
	}
	return(M);
    }





    public Matrix scale(double t) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=a[i][j]*t;
	    }
	}
	return(M);
    }


    public void nicePrint(double d) {
	if(Math.abs(d)<.000000000000001) System.out.print("0.0");
	else System.out.print(d);
    }

    public void print() {

	System.out.println("matrix");
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		nicePrint(a[i][j]);
		System.out.print(" ");
	    }
	    System.out.println("");
	}
    }




    public double det() {

	double a1=a[0][0]*a[1][1]*a[2][2];
	double a2=a[0][1]*a[1][2]*a[2][0];
	double a3=a[0][2]*a[1][0]*a[2][1];

	double b1=a[2][0]*a[1][1]*a[0][2];
	double b2=a[2][1]*a[1][2]*a[0][0];
	double b3=a[2][2]*a[1][0]*a[0][1];

	return(a1+a2+a3-b1-b2-b3);
    }


    public Matrix inverse() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];

	double d=this.det();

	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j]/d;
	    }
	}
	return(TM);
    }


    public Matrix transpose() {

	Matrix TM=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=a[i][j];
	    }
	}
	return(TM);
    }

    public Matrix transposeSkew() {
	Matrix TM=this.transpose();
	TM.a[0][2]=-TM.a[0][2];
	TM.a[1][2]=-TM.a[1][2];
	TM.a[2][0]=-TM.a[2][0];
	TM.a[2][1]=-TM.a[2][1];
	return(TM);
    }

    public Matrix skew() {
	Matrix TM=new Matrix(this);
	TM.a[0][2]=-TM.a[0][2];
	TM.a[1][2]=-TM.a[1][2];
	TM.a[2][0]=-TM.a[2][0];
	TM.a[2][1]=-TM.a[2][1];
	return(TM);
    }

    

    public double trace() {
	double t=a[0][0]+a[1][1]+a[2][2];
	return(t);
    }


    public Vector act(Vector V) {
	return act(this,V);
    }
    

    public static Vector act(Matrix M,Vector V) {
	Vector W=new Vector(0,0,0);
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		W.x[i]=W.x[i]+M.a[i][j]*V.x[j];
	    }
	}
	W.tag=V.tag;
	return(W);
    }

    public boolean isNearIdentity(double tol) {
	for(int i=0;i<3;++i) {
	    if(Math.abs(a[i][i]-1)>tol) return false;
	}
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if((i!=j)&&(Math.abs(a[i][j])>tol)) return false;
	    }
	}
	return true;
    }

    


    public static Matrix fromFrame(Vector V1,Vector V2) {
	Vector V3=Vector.cross(V1,V2);
	Matrix m=new Matrix();
	Vector[] M={V1,V2,V3};
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		m.a[i][j]=M[j].x[i];
	    }
	}
	return(m);
    }


    public static Matrix fromFrameInverse(Vector V1,Vector V2) {
	Matrix m=fromFrame(V1,V2);
	m=m.inverse();
	return(m);
    }




}




