import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**This is wrapper class for a list of points in the
   plane.  The main routines in this class are 
   1. taking the convex hull of a finite set of points.
   2. intersecting two convex polygons.
**/


public class PolygonWrapper {
    Complex[] z=new Complex[5];
    int count;
    int name;

    /**Constructors**/
    public PolygonWrapper() {}
    
    public PolygonWrapper(PolygonWrapper P) {
	this.count=P.count;
	for(int i=0;i<P.count;++i) {
             z[i]=new Complex(P.z[i]);
	}
    }

    

    public PolygonWrapper(int cc,Complex[] zz) {
	this.count=cc;
	for(int i=0;i<cc;++i) {
             z[i]=new Complex(zz[i]);
	}
    }


    /**For drawing the polygon**/

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(z[0].x,z[0].y);
	for(int i=0;i<count;++i) {
	    gp.lineTo(z[i].x,z[i].y);
	}
	gp.closePath();
	return(gp);
    }


/**printout**/
    public void print() {
	System.out.println("count "+count);
	for(int i=0;i<count;++i) z[i].print();
    }


    public Complex center() {
	Complex w=new Complex();
	for(int i=0;i<count;++i) {
	    w=Complex.plus(w,this.z[i]);
	}
	w.x=w.x/count;
	w.y=w.y/count;
	return(w);
    }


    public PolygonWrapper translate(Complex w) {
	PolygonWrapper P=new PolygonWrapper(this);
	for(int i=0;i<count;++i) {
	    int t=P.z[i].tag;
	    P.z[i]=Complex.plus(w,P.z[i]);
	    P.z[i].tag=t;
	}
	return P;
    }

    public PolygonWrapper translate(double x) {
	Complex z=new Complex(x,0);
	return this.translate(z);
    }
    
    
}
