import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class is the product of two right triangles.
   In each case the right-angled vertex is listed last*/

public class TriangleProduct {
    PolygonWrapper[] P=new PolygonWrapper[2];
    int parity;
    int COUNT;
    int[] SUB=new int[100];
    
    public static PolygonWrapper initial() {
	Complex[] Z=new Complex[3];
	Z[0]=new Complex(0,0);
	Z[1]=new Complex(1,0);
	Z[2]=Complex.plus(Z[1],Chain.rootOfUnity5(1));
	Z[2]=Z[2].scale(.5);
	TriangleProduct T=new TriangleProduct();
	PolygonWrapper P=new PolygonWrapper(3,Z);
	return P;
    }

    public static PolygonWrapper[] sub(PolygonWrapper P) {
	Complex dir=Complex.minus(P.z[0],P.z[1]);
	dir=Complex.times(dir,new Complex(0,1));
	Complex w=Complex.plus(P.z[2],dir);
	Complex u=Vector.findCross2(P.z[0],P.z[1],P.z[2],w);
        Complex[] Z0=new Complex[3];
	Complex[] Z1=new Complex[3];
	Z0[0]=new Complex(P.z[0]);
	Z0[1]=new Complex(P.z[2]);
	Z0[2]=new Complex(u);
	Z1[0]=new Complex(P.z[2]);
	Z1[1]=new Complex(P.z[1]);
	Z1[2]=new Complex(u);
	PolygonWrapper P0=new PolygonWrapper(3,Z0);
	PolygonWrapper P1=new PolygonWrapper(3,Z1);
	PolygonWrapper[] SP={P0,P1};
	return SP;
    }


    public static Complex random(PolygonWrapper P) {
	double[] r=new double[3];
	double s=0;
	for(int i=0;i<3;++i) {
            r[i]=Math.random();
	    s=s+r[i];
	}
	for(int i=0;i<3;++i) r[i]=r[i]/s;
	Complex w=new Complex(0,0);
	for(int i=0;i<3;++i) {
	    w=Complex.plus(w,P.z[i].scale(r[i]));
	}
	return w;
    }

    public void print() {
	System.out.println("parity "+parity);
	P[0].print();
	P[1].print();
    }

}


