import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**The input to this class is a convex polygon and the output is a
   list of the Voronoi cells of the vertices*/

public class VoronoiPolygon  {

    public static Complex[] cellVertices(Complex[] Z) {
	int L=Z.length;
	Complex[] LIST=new Complex[1000];
	int count=0;
	for(int i=0;i<L;++i) {
	    PolygonWrapper P=cell(Z,i);
	    Complex[] W=P.toPoints();
	    for(int j=0;j<W.length;++j) {
		LIST[count]=new Complex(W[j]);
		++count;
	    }
	}
	Complex[] LIST2=new Complex[count];
	for(int i=0;i<count;++i) LIST2[i]=LIST[i];
	return LIST2;
    }

    public static PolygonWrapper cell(Complex[] Z,int k) {
	Complex[] W=intersectionList(Z,k);
	PolygonWrapper P=new PolygonWrapper(W.length,W);
	P=PolygonWrapper.convexHull(P);
	return P;
    }
    
    
    /**returns true of the complex number w is nearest the kth vertex of Z*/

    public static boolean isNearest(Complex[] Z,Complex w,int k) {
	double dist=Complex.dist(w,Z[k]);
	for(int i=0;i<Z.length;++i) {
	    double test=Complex.dist(w,Z[i]);
	    if(i!=k) {
		if(test<dist-.00000001) return false;
	    }
	}
	return true;
    }
    

    public static Complex[] intersectionList(Complex[] Z,int k) {
	Complex[] W=intersectionList(Z);
	int count=0;
	Complex[] LIST=new Complex[W.length];
	for(int i=0;i<W.length;++i) {
	    if(isNearest(Z,W[i],k)==true) {
		LIST[count]=new Complex(W[i]);
		++count;
	    }
	}
	Complex[] LIST2=new Complex[count+1];
	for(int i=0;i<count;++i) LIST2[i]=LIST[i];
	LIST2[count]=new Complex(Z[k]);
	return LIST2;
    }
    
    

    public static Complex[] intersectionList(Complex[] Z) {
	int count=0;
	Complex[][] W=bisectorList(Z);
	Path2D.Double gp=GraphicsHelp.toPath(Z);
	int N=W.length;
	Complex[] LIST=new Complex[N*(N-1)/2];
	for(int i=0;i<N;++i) {
	    for(int j=i+1;j<N;++j) {
		Complex z=Vector.findCross2(W[i][0],W[i][1],W[j][0],W[j][1]);
		if(gp.contains(z.x,z.y)==true) {
		    LIST[count]=z;
		    ++count;
		}
	    }
	}
	Complex[] LIST2=new Complex[count+Z.length];
	for(int i=0;i<count;++i) LIST2[i]=LIST[i];
	Complex[] M=midpointList(Z);
	for(int i=0;i<Z.length;++i) {
	    LIST2[i+count]=M[i];
	}
	return LIST2;
    }
    
	

    /**gets all bisectors of polygon*/

    public static Complex[][] bisectorList(Complex[] Z) {
	int N=Z.length;
	int count=0;
	Complex[][] W=new Complex[N*(N-1)/2][2];
	for(int i=0;i<N;++i) {
	    for(int j=i+1;j<N;++j) {
		Complex z0=Z[i];
		Complex z1=Z[j];
		Complex z2=Complex.plus(z0,z1);
		z2=z2.scale(.5);
		Complex z3=Complex.minus(z0,z1);
		z3=Complex.times(z3,new Complex(0,1));
		W[count][0]=z2;
		W[count][1]=Complex.plus(z2,z3);
		++count;
	    }
	}
	return W;
    }



    /**gets midpoints of polygon*/
    public static Complex[] midpointList(Complex[] Z) {
	int N=Z.length;
	int count=0;
	Complex[] W=new Complex[N];
	for(int i=0;i<N;++i) {
	    int j=(i+1)%N;
	    	Complex z0=Z[i];
		Complex z1=Z[j];
		Complex z2=Complex.plus(z0,z1);
		z2=z2.scale(.5);
		W[i]=z2;
	}
	return W;
    }

    
    
    
}


