
/**This short class animates the polyhedron exchange display**/

public class Animator implements Runnable {
    Manager M;
    boolean halt;

    public Animator() {}

    public Animator(Manager MM) {
	this.M=MM;
    }

    public void run() {
	System.out.println("used");
	halt=false;
	int dir=0;
	int p=M.F.S.I[0].val;
	int q=M.F.S.I[1].val;
	int count=0;
	
	while(halt==false) {
	    if((dir==0)&&(p<q-1)) ++p;
	    if((dir==0)&&(p==q-1)) {
		dir=1;
		++count;
	    }
	    if((dir==1)&&(p>1)) --p;
	    if((dir==1)&&(p==1)) {
		dir=0;
		++count;
	    }
	    M.F.S.I[0].val=p;
	    int[] s=viewState12(count);
	    M.F.STATE[0]=s[0];
	    M.F.STATE[1]=s[1];
	    s=viewState34(count);
	    M.F.STATE[0]=s[0];
	    M.F.STATE[1]=s[1];
	    double d=1-M.F.SPEED.getValue();
	    long time=doubleToNano(d);
	    if(time>0) sleep(time);
	    M.F.repaint();
	}
    }

    int[] viewState12(int a) {
	int[][] b={{0,0},{0,1},{1,0},{1,1},{2,0},{2,1},{3,0},{3,1},{4,0},{4,1},{5,0},{5,1}};
	return b[a%12];
    }

    int[] viewState34(int a) {
	int[][] b={{0,0},{4,1},{5,0},{5,1},{4,0},{0,1},{3,0},{1,1},{2,0},{2,1},{1,0},{3,1}};
	return b[a%12];
    }



	
    public static long doubleToNano(double d0) {
       double d=d0/4+1.0/2;
	double d2=Math.pow(1.1,300*d);
	long time=(long)(d2);
	return time;
    }
    

    /**sleep in nanosecs*/
    
    public static void sleep(long time) {
	long t0=System.nanoTime();
	long t1=t0;
	while(t1-t0<time) {
	    t1=System.nanoTime();
	}
    }


    
}



